/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui.tabbed;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.ui.tabbed.PropertiesSectionDescriptor;

public class PropertiesTabDescriptor
extends AbstractTabDescriptor {
    IPropertyContext _propertyContext;
    IRendererContext _rendererContext;
    IPropertyGroup _group;

    public PropertiesTabDescriptor(IPropertyContext context, IRendererContext rendererContext, IPropertyGroup group) {
        this._propertyContext = context;
        this._rendererContext = rendererContext;
        this._group = group;
    }

    public String getCategory() {
        return "category";
    }

    public String getId() {
        return this._group.getId();
    }

    public String getLabel() {
        return this._group.getName();
    }

    public List<ISectionDescriptor> getSectionDescriptors() {
        LinkedList<ISectionDescriptor> desc = new LinkedList<ISectionDescriptor>();
        IRenderers renderers = this._rendererContext.getRenderers();
        IProperties properties = this._propertyContext.getProperties();
        Collection<Object> childGroups = Collections.emptyList();
        if (renderers != null) {
            childGroups = renderers.getGroups(properties, this._group);
        }
        List childProperties = properties.getItems(this._group);
        if (childGroups.size() == 0 && childProperties.size() == 0) {
            return desc;
        }
        for (IPropertyGroup iPropertyGroup : childGroups) {
            desc.add(this.createSectionDescriptor(this._propertyContext, this._rendererContext, iPropertyGroup));
        }
        return desc;
    }

    protected ISectionDescriptor createSectionDescriptor(IPropertyContext context, IRendererContext rendererContext, IPropertyGroup group) {
        return new PropertiesSectionDescriptor(context, rendererContext, group);
    }
}

