/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.RePackage;

public class ReplicableElementExt {
    public static Collection<CatalogElement> getReferencingReplicableElements(EObject element) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        List links = EObjectExt.getReferencers((EObject)element, (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
        for (EObject object : links) {
            CatalogElementLink link;
            if (!(object instanceof CatalogElementLink) || (link = (CatalogElementLink)object).getSource() == null) continue;
            elements.add(link.getSource());
        }
        return elements;
    }

    public static Collection<CatalogElement> getReferencingReplicas(EObject element) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        List links = EObjectExt.getReferencers((EObject)element, (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
        for (EObject object : links) {
            CatalogElementLink link;
            if (!(object instanceof CatalogElementLink) || (link = (CatalogElementLink)object).getSource() == null || link.getSource().getKind() == CatalogElementKind.REC) continue;
            elements.add(link.getSource());
        }
        return elements;
    }

    public static Collection<CatalogElementLink> getReferencingLinks(EObject source) {
        ArrayList<CatalogElementLink> elements = new ArrayList<CatalogElementLink>();
        List links = EObjectExt.getReferencers((EObject)source, (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
        for (EObject object : links) {
            if (!(object instanceof CatalogElementLink)) continue;
            CatalogElementLink link = (CatalogElementLink)object;
            elements.add(link);
        }
        return elements;
    }

    public static EObject getReferencingElement(CatalogElement source, EObject originElement) {
        for (CatalogElementLink link : source.getOwnedLinks()) {
            if (link.getTarget() == null || link.getOrigin() == null || link.getOrigin().getTarget() == null || !link.getOrigin().getTarget().equals(originElement)) continue;
            return link.getTarget();
        }
        return null;
    }

    public static Collection<CatalogElement> getReplicas(CatalogElement source) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        List links = EObjectExt.getReferencers((EObject)source, (EReference)RePackage.Literals.CATALOG_ELEMENT__ORIGIN);
        for (EObject object : links) {
            if (!(object instanceof CatalogElement)) continue;
            CatalogElement link = (CatalogElement)object;
            elements.add(link);
        }
        return elements;
    }
}

