/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.merge.scope;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyChangeEvent;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyListener;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.merge.ExtendedComparison;
import org.polarsys.capella.core.transition.common.merge.scope.IModelScopeFilter;
import org.polarsys.capella.core.transition.common.merge.scope.ReferenceModelScope;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class ReScope
extends ReferenceModelScope
implements INotifyListener {
    CatalogElement element;
    ITraceabilityHandler handler;
    Collection<? extends EObject> _initialElements;

    public ReScope(CatalogElement element, ITraceabilityHandler handler, Collection<? extends EObject> elements, IContext context) {
        super(elements, context);
        this.element = element;
        this.handler = handler;
        this._initialElements = elements;
    }

    protected abstract boolean isSource();

    public Collection<? extends EObject> getInitialElements() {
        return this._initialElements;
    }

    protected boolean shouldAddTraceability(EObject value, Role role, IContext context) {
        return !ReplicableElementHandlerHelper.getInstance(context).isUnmodifiableElement(value, context);
    }

    protected void addTraceabilityLink(EObject value, IContext contextParameter) {
        String oppositeScope;
        ExtendedComparison comparison = (ExtendedComparison)this.context.get((Object)"MERGE_COMPARISON");
        Role destinationRole = this.isSource() ? Role.REFERENCE : Role.TARGET;
        Role oppositeRole = !this.isSource() ? Role.REFERENCE : Role.TARGET;
        String destinationScope = this.isSource() ? "capella.re.SOURCE__ADDED_ELEMENTS" : "capella.re.TARGET__ADDED_ELEMENTS";
        String string = oppositeScope = !this.isSource() ? "capella.re.SOURCE__ADDED_ELEMENTS" : "capella.re.TARGET__ADDED_ELEMENTS";
        if (this.shouldAddTraceability(value, destinationRole, this.context)) {
            CatalogElement source;
            IMatch match = comparison.getMapping().getMatchFor(value, destinationRole);
            EObject oppositeValue = match.get(oppositeRole);
            CatalogElementLink link = ReplicableElementHandlerHelper.getInstance(this.context).addLink(this.context, this.handler, this.element, value, oppositeValue);
            ContextScopeHandlerHelper.getInstance((IContext)this.context).add(destinationScope, (EObject)link, this.context);
            if (!this.isSource() && (source = ReplicableElementHandlerHelper.getInstance(this.context).getSource(this.context)) != null && oppositeValue != null && this.shouldAddTraceability(value, oppositeRole, this.context)) {
                link = ReplicableElementHandlerHelper.getInstance(this.context).addLink(this.context, this.handler, source, oppositeValue, value);
                ContextScopeHandlerHelper.getInstance((IContext)this.context).add(oppositeScope, (EObject)link, this.context);
            }
        }
    }

    public boolean add(EObject element) {
        System.out.println(NLS.bind((String)"ADD {0}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)element)}));
        if (element instanceof CatalogElement && !ContextScopeHandlerHelper.getInstance((IContext)this.context).contains("capella.re.UNMERGEABLE_ELEMENTS", element, this.context)) {
            ((CatalogElement)element).setKind(CatalogElementKind.RPL);
        }
        this.addTraceabilityLink(element, this.context);
        return super.add(element);
    }

    public boolean add(EObject element, boolean includeChildren) {
        System.out.println(NLS.bind((String)"ADD-includeChildren {0}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)element)}));
        return super.add(element, includeChildren);
    }

    public boolean add(EObject source, EReference reference, EObject value) {
        System.out.println(NLS.bind((String)"ADD {0} {1} {2}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)source), reference.getName(), EObjectLabelProviderHelper.getText((EObject)value)}));
        if (reference.isContainment()) {
            this.addTraceabilityLink(value, this.context);
        }
        if (ReplicableElementHandlerHelper.getInstance(this.context).isUnmodifiableElement(source, this.context)) {
            return false;
        }
        if (reference.isContainment() && ReplicableElementHandlerHelper.getInstance(this.context).isUnmodifiableElement(value, this.context)) {
            return false;
        }
        return super.add(source, reference, value);
    }

    public boolean add(EObject source, EAttribute attribute, Object value) {
        System.out.println(NLS.bind((String)"ADD {0} {1} {2}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)source), attribute.getName(), EObjectLabelProviderHelper.getText((Object)value)}));
        return super.add(source, attribute, value);
    }

    public void build(IModelScopeFilter filter) {
        super.build(filter);
    }

    public boolean covers(EObject element) {
        return super.covers(element);
    }

    public boolean remove(EObject element) {
        System.out.println(NLS.bind((String)"REMOVE {0}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)element)}));
        ReplicableElementHandlerHelper.getInstance(this.context).addDeletableElement(element, this.context);
        this._roots.remove(element);
        this.removeFromScope(element);
        return true;
    }

    public void removeFromScope(EObject element) {
        System.out.println(NLS.bind((String)"REMOVE-fromScope {0}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)element)}));
        super.removeFromScope(element);
    }

    public Object move(EObject source, EStructuralFeature feature, int newPosition, int oldPosition) {
        return super.move(source, feature, newPosition, oldPosition);
    }

    public boolean remove(EObject source, EAttribute attribute, Object value) {
        System.out.println(NLS.bind((String)"REMOVE {0} {1} {2}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)source), attribute.getName(), EObjectLabelProviderHelper.getText((Object)value)}));
        return super.remove(source, attribute, value);
    }

    public boolean remove(EObject source, EReference reference, EObject value) {
        System.out.println(NLS.bind((String)"REMOVE {0} {1} {2}", (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)source), reference.getName(), EObjectLabelProviderHelper.getText((EObject)value)}));
        if (reference.isContainment()) {
            ReplicableElementHandlerHelper.getInstance(this.context).addDeletableElement(value, this.context);
            return true;
        }
        return super.remove(source, reference, value);
    }

    protected List<EObject> retains(List<EObject> object) {
        List result = super.retains(object);
        result.removeAll(ReplicableElementHandlerHelper.getInstance(this.context).getDeletableElements(this.context));
        return result;
    }

    public void notifyChanged(INotifyChangeEvent event, IContext context) {
    }
}

