/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.re2rpl.create.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.ICompoundProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IModifiedProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.constants.IReConstants;
import org.polarsys.capella.common.re.handlers.location.LocationHandlerHelper;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.core.transition.common.capellaHelpers.HashMapSet;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReplicaContentProperty
extends AbstractProperty
implements ICompoundProperty,
IModifiedProperty,
IEditableProperty {
    private static String LINKS = "TEMPORARYLINKS";

    public Object getValue(IPropertyContext context) {
        CatalogElement target = (CatalogElement)context.getCurrentValue(context.getProperties().getProperty("itarget"));
        IContext ctx = (IContext)context.getSource();
        if (ctx.get((Object)LINKS) != null) {
            return ctx.get((Object)LINKS);
        }
        HashSet<CatalogElementLink> links = new HashSet<CatalogElementLink>();
        CatalogElement source = (CatalogElement)context.getCurrentValue(context.getProperties().getProperty("isource"));
        ReplicableElementHandlerHelper.getInstance(ctx).createInitialReplica(source, target, ctx);
        HashSet<CatalogElementLink> toDelete = new HashSet<CatalogElementLink>();
        if (IReConstants.ENABLE_SUB_INSTANCIATION()) {
            for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(ctx).getAllElementsLinks(target)) {
                toDelete.add(link.getOrigin());
                links.add(link);
            }
        } else {
            for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(ctx).getElementsLinks(target)) {
                toDelete.add(link.getOrigin());
                links.add(link);
            }
        }
        HashMapSet toCreate = new HashMapSet();
        ArrayList<CatalogElement> usedSource = new ArrayList<CatalogElement>();
        usedSource.add(source);
        if (IReConstants.ENABLE_SUB_INSTANCIATION()) {
            usedSource.addAll(ReplicableElementHandlerHelper.getInstance(ctx).getAllUsedReplicableElements(source));
        }
        ArrayList<CatalogElement> usedTarget = new ArrayList<CatalogElement>();
        usedTarget.add(target);
        if (IReConstants.ENABLE_SUB_INSTANCIATION()) {
            usedTarget.addAll(ReplicableElementHandlerHelper.getInstance(ctx).getAllUsedReplicableElements(target));
        }
        for (CatalogElement element : usedSource) {
            for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(ctx).getElementsLinks(element)) {
                toCreate.put((Object)element, (Object)link);
            }
        }
        for (CatalogElement element : toCreate.keySet()) {
            toCreate.get((Object)element).removeAll(toDelete);
            CatalogElement targetElement = null;
            for (CatalogElement targetElementq : usedTarget) {
                if (!targetElementq.getOrigin().equals(element)) continue;
                targetElement = targetElementq;
                break;
            }
            Collection<CatalogElementLink> targetLinks = ReplicableElementHandlerHelper.getInstance(ctx).createTargetLinks(targetElement, toCreate.get((Object)element), ctx);
            links.addAll(targetLinks);
        }
        ctx.put((Object)LINKS, links);
        return links;
    }

    public IStatus validate(Object newValue, IPropertyContext context) {
        IContext ctx = (IContext)context.getSource();
        Object useDefault = context.getCurrentValue(context.getProperties().getProperty("useDefaultLocation"));
        boolean isUseDefault = !Boolean.FALSE.equals(useDefault);
        HashSet links = (HashSet)newValue;
        HashSet<CatalogElementLink> linksInvalid = new HashSet<CatalogElementLink>();
        for (CatalogElementLink link : links) {
            EObject defaultLocation;
            EObject location;
            EObject currentLocation = LocationHandlerHelper.getInstance(ctx).getCurrentLocation(link, ctx);
            if (currentLocation != null || (location = LocationHandlerHelper.getInstance(ctx).getLocation(link, link.getOrigin(), ctx)) != null || isUseDefault && (defaultLocation = LocationHandlerHelper.getInstance(ctx).getDefaultLocation(link, link.getOrigin(), ctx)) != null) continue;
            linksInvalid.add(link);
        }
        if (!linksInvalid.isEmpty()) {
            return new Status(4, "org.polarsys.capella.common.re", "Some elements need to be stored in the model");
        }
        return Status.OK_STATUS;
    }

    public Object getType() {
        return Collection.class;
    }

    public Object toType(Object value, IPropertyContext context) {
        return value;
    }

    public void setValue(IPropertyContext context) {
        boolean isUseDefault;
        IContext ctx = (IContext)context.getSource();
        HashSet links = (HashSet)context.getCurrentValue((IProperty)this);
        Object useDefault = context.getCurrentValue(context.getProperties().getProperty("useDefaultLocation"));
        boolean bl = isUseDefault = !Boolean.FALSE.equals(useDefault);
        if (links != null) {
            for (CatalogElementLink link : links) {
                EObject defaultLocation;
                EObject currentLocation = LocationHandlerHelper.getInstance(ctx).getCurrentLocation(link, ctx);
                if (currentLocation != null) continue;
                EObject location = LocationHandlerHelper.getInstance(ctx).getLocation(link, link.getOrigin(), ctx);
                if (location != null) {
                    LocationHandlerHelper.getInstance(ctx).setCurrentLocation(link, location, ctx);
                    continue;
                }
                if (!isUseDefault || (defaultLocation = LocationHandlerHelper.getInstance(ctx).getDefaultLocation(link, link.getOrigin(), ctx)) == null) continue;
                LocationHandlerHelper.getInstance(ctx).setCurrentLocation(link, defaultLocation, ctx);
            }
        }
        CatalogElement replica = (CatalogElement)context.getCurrentValue(context.getProperties().getProperty("itarget"));
        for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(ctx).getAllElementsLinks(replica)) {
            if (!ContextScopeHandlerHelper.getInstance((IContext)ctx).contains("CREATED_LINKS", (EObject)link, ctx)) continue;
            ContextScopeHandlerHelper.getInstance((IContext)ctx).add("CREATED_LINKS_TO_KEEP", (EObject)link, ctx);
        }
    }

    public String[] getRelatedProperties() {
        return new String[]{"itarget", "useDefaultLocation", "locationTarget"};
    }

    public void updatedValue(IProperty property, IPropertyContext context) {
        if ("itarget".equals(property.getId()) || "isource".equals(property.getId())) {
            IContext ctx = (IContext)context.getSource();
            ctx.put((Object)LINKS, null);
            ReplicableElementHandlerHelper.getInstance(ctx).cleanVirtualLinks(ctx);
            LocationHandlerHelper.getInstance(ctx).cleanLocations(ctx);
        }
    }

    public boolean isModified(IPropertyContext context) {
        return true;
    }
}

