/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class ReportManagerFilter
extends Filter {
    ReportManagerRegistry reg = null;
    Appender theAppender = null;

    public ReportManagerFilter(Appender appender) {
        this.theAppender = appender;
    }

    public int decide(LoggingEvent event) {
        String level = event.getLevel().toString();
        String componentName = event.getLoggerName();
        this.reg = ReportManagerRegistry.getInstance();
        ConfigurationInstance config = this.reg.getComponentConfiguration(componentName);
        if (config == null) {
            config = this.reg.getComponentConfiguration("Default");
        }
        List<OutputConfiguration> configsList = config.getOutputConfiguration();
        for (OutputConfiguration outputConfiguration : configsList) {
            String appenderName = this.theAppender.getName();
            if (!appenderName.equals(outputConfiguration.getOutputName())) continue;
            List<LogLevel> logslevels = outputConfiguration.getLogLevel();
            for (LogLevel logLevel : logslevels) {
                if (!logLevel.isValue() || !level.equals(logLevel.getName())) continue;
                return 1;
            }
        }
        return -1;
    }
}

