/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.refinement.merge.MergeActivator;
import org.polarsys.capella.core.refinement.merge.exception.MergeException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.helpers.ScenarioHelper;
import org.polarsys.capella.core.refinement.merge.merger.IScenarioMerger;
import org.polarsys.capella.core.refinement.merge.merger.RecursiveMergerUML2;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.update.UpdateMergedScenario;
import org.polarsys.capella.core.refinement.merge.utils.MergeUtils;
import org.polarsys.capella.core.refinement.merge.validation.MergeConstraintFilter;
import org.polarsys.capella.core.refinement.preferences.services.RefinementPrefServices;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.validation.CapellaValidationActivator;

public class DefaultScenarioMerger
implements IScenarioMerger {
    protected Scenario _result = null;

    @Override
    public Scenario doMerge(Scenario sc) throws MergeException {
        try {
            Scenario previousMergeResult = MergeHelper.hasBeenAlreadyMerged(sc);
            this._result = previousMergeResult == null ? this.performMerge(sc) : this.performUpdate(sc, previousMergeResult);
            CapabilityRealization cr = (CapabilityRealization)sc.eContainer();
            HoldingResourceHelper.ensureMoveElement((EObject)this._result, (EObject)cr);
            cr.getOwnedScenarios().add((Object)this._result);
        }
        catch (MergeException exception) {
            String errDetails = exception.getMessage();
            CapabilityRealization cr = (CapabilityRealization)sc.eContainer();
            String msg = NLS.bind((String)MergeMessages.mergeErrorTopMessage, (Object[])new Object[]{sc.getName(), cr.getName(), errDetails});
            throw new MergeException(msg, exception);
        }
        return this._result;
    }

    @Override
    public boolean postTreatment(Scenario sc) throws ProcessorException {
        return true;
    }

    @Override
    public boolean preTreatment(Scenario sc) throws ProcessorException {
        boolean result = true;
        if (RefinementPrefServices.isPreValidationForMergeActivated()) {
            int severity = this.validate(sc);
            Logger logger = MergeActivator.getDefault().getLogger();
            EmbeddedMessage emsg = null;
            switch (severity) {
                case 4: {
                    emsg = new EmbeddedMessage(MergeMessages.preValidationRaiseErrors, "Refinement", (Object)sc);
                    if (RefinementPrefServices.isErrorOnPreValidationStopMerge()) {
                        logger.error((Object)emsg);
                        result = false;
                        break;
                    }
                    logger.warn((Object)emsg);
                    break;
                }
                case 2: {
                    emsg = new EmbeddedMessage(MergeMessages.preValidationRaiseWarnings, "Refinement", (Object)sc);
                    logger.warn((Object)emsg);
                    break;
                }
                case 1: {
                    emsg = new EmbeddedMessage(MergeMessages.preValidationRaiseInfos, "Refinement", (Object)sc);
                    logger.info((Object)emsg);
                }
            }
        }
        return result;
    }

    private int validate(Scenario sc) {
        IBatchValidator validator = CapellaValidationActivator.getDefault().getCapellaValidatorAdapter().getValidator();
        MergeConstraintFilter filter = new MergeConstraintFilter();
        validator.addConstraintFilter((IConstraintFilter)filter);
        int errorLevel = 0;
        Iterator<Scenario> iterator = ScenarioHelper.getRefinedScenarii(sc, true).iterator();
        while (iterator.hasNext()) {
            Diagnostician diagnostician = new Diagnostician();
            Scenario s = iterator.next();
            Diagnostic diagnostic = diagnostician.validate((EObject)s);
            if (diagnostic.getSeverity() <= errorLevel) continue;
            errorLevel = diagnostic.getSeverity();
        }
        validator.removeConstraintFilter((IConstraintFilter)filter);
        return errorLevel;
    }

    protected Scenario performMerge(Scenario sc) throws MergeException {
        RecursiveMergerUML2 merger = new RecursiveMergerUML2(sc);
        merger.performMerge();
        return merger.getResult();
    }

    protected Scenario performUpdate(Scenario sc, Scenario scm) throws MergeException {
        Scenario newMergedResult = null;
        newMergedResult = this.performMerge(sc);
        UpdateMergedScenario update = new UpdateMergedScenario(scm);
        update.update(newMergedResult);
        ArrayList<EObject> objectsToDelete = new ArrayList<EObject>();
        objectsToDelete.add((EObject)scm);
        List features = ScenarioExt.getElementOfInterestOnScenario();
        for (EStructuralFeature feature : features) {
            objectsToDelete.addAll((List)scm.eGet(feature));
        }
        MergeUtils.deleteElements(objectsToDelete);
        CapabilityRealization cr = (CapabilityRealization)sc.eContainer();
        cr.getOwnedScenarios().remove((Object)scm);
        return newMergedResult;
    }

    public void reconnectInvolvment(CapabilityRealization capability, Scenario scenario) {
        for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
            AbstractInstance ai = ir.getRepresentedInstance();
            this.ensureCapabilityInvolvment(capability, ai);
        }
    }

    private void ensureCapabilityInvolvment(CapabilityRealization capability, AbstractInstance ai) {
        boolean found = false;
        AbstractType type = ai.getAbstractType();
        for (SystemComponentCapabilityRealizationInvolvement sccr : capability.getInvolvedSystemComponents()) {
            if (sccr.getInvolved() != type) continue;
            found = true;
        }
        for (ActorCapabilityRealizationInvolvement acri : capability.getInvolvedActors()) {
            if (acri.getInvolved() != type) continue;
            found = true;
        }
        if (!found) {
            SystemComponentCapabilityRealizationInvolvement sccr;
            sccr = CsFactory.eINSTANCE.createSystemComponentCapabilityRealizationInvolvement();
            capability.getOwnedSystemComponentCapabilityRealizations().add((Object)sccr);
            sccr.setInvolver((InvolverElement)capability);
            sccr.setInvolved((InvolvedElement)type);
        }
    }
}

