/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.processor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.refinement.merge.exception.MergeException;
import org.polarsys.capella.core.refinement.merge.merger.DefaultScenarioMerger;
import org.polarsys.capella.core.refinement.merge.merger.IScenarioMerger;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public final class ScenarioMergeProcessor
implements IProcessor {
    protected Scenario _result;
    protected Scenario _context;
    protected CapabilityRealization _target;
    protected IScenarioMerger _merger;

    public ScenarioMergeProcessor() {
        this._merger = new DefaultScenarioMerger();
    }

    public ScenarioMergeProcessor(IScenarioMerger merger) {
        this._merger = merger == null ? new DefaultScenarioMerger() : merger;
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        boolean b = true;
        try {
            try {
                b = this._merger.preTreatment(this._context);
            }
            catch (MergeException exception) {
                throw new ProcessorException(NLS.bind((String)MergeMessages.preValidationErr, (Object[])new Object[]{this._context.getName(), this._target.getName()}), (IProcessor)this, (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            if (!b) {
                throw new ProcessorException(NLS.bind((String)MergeMessages.preValidationErr, (Object[])new Object[]{this._context.getName(), this._target.getName()}), (IProcessor)this);
            }
            throw throwable;
        }
        if (!b) {
            throw new ProcessorException(NLS.bind((String)MergeMessages.preValidationErr, (Object[])new Object[]{this._context.getName(), this._target.getName()}), (IProcessor)this);
        }
        try {
            this._result = this._merger.doMerge(this._context);
        }
        catch (Exception exception) {
            throw new ProcessorException(NLS.bind((String)MergeMessages.genericError, (Object[])new Object[]{this._context.getName(), this._target.getName()}), (IProcessor)this, (Throwable)exception);
        }
        try {
            this._merger.postTreatment(this._context);
        }
        catch (MergeException exception) {
            throw new ProcessorException(NLS.bind((String)MergeMessages.postValidationErr, (Object[])new Object[]{this._context.getName(), this._target.getName()}), (IProcessor)this, (Throwable)exception);
        }
        HoldingResourceHelper.ensureMoveElement((EObject)this._result, (EObject)this._target);
        this._target.getOwnedScenarios().add((Object)this._result);
        HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)this._target));
    }

    public Object getResult() {
        return this._result;
    }

    public void setContext(ModelElement context) {
        if (!context.eClass().isSuperTypeOf(InteractionPackage.Literals.SCENARIO)) {
            throw new ClassCastException();
        }
        this._context = (Scenario)context;
    }

    public void setContext(List<ModelElement> context) {
        throw new UnsupportedOperationException();
    }

    public void setTarget(NamedElement target) {
        if (!target.eClass().isSuperTypeOf(LaPackage.Literals.CAPABILITY_REALIZATION)) {
            throw new ClassCastException();
        }
        this._target = (CapabilityRealization)target;
    }

    public Object getName() {
        return MergeMessages.mergeProcessorName;
    }
}

