/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import java.text.Collator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractMessageDialogWithViewer;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.validation.ui.ide.messages.QuickfixMessages;

public class EObjectNavigatorDialog
extends AbstractMessageDialogWithViewer {
    protected String comboLabel;
    protected String elementPrefix;
    private AbstractContextMenuFiller _contextMenuManagerFiller;
    protected static final int DEFAULT_COLOR_FOR_REVELANT_ELEMENTS = 9;
    protected int foregroundColorForRelevantElements;
    protected List<? extends EObject> revelantElements;
    protected Collection<List<EObject>> cycles;
    protected Combo combo;

    public void setCycles(Collection<List<EObject>> cycles) {
        this.cycles = cycles;
    }

    public EObjectNavigatorDialog(List<? extends EObject> elements, String dialogTitle, String dialogMessage, String dialogComboLabel, String elementPrefix) {
        this(elements, dialogTitle, dialogMessage, dialogComboLabel, elementPrefix, 2, new String[]{Messages.AbstractViewerDialog_OK_Title}, 9);
    }

    public EObjectNavigatorDialog(List<? extends EObject> elements, String dialogTitle, String dialogMessage, String dialogComboLabel, String elementPrefix, int dialogImageType, String[] dialogButtonLabels, int foregroundColorForReferencingElements) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), dialogTitle, null, dialogMessage, dialogImageType, dialogButtonLabels, 0);
        this.comboLabel = dialogComboLabel;
        this.elementPrefix = elementPrefix;
        this.revelantElements = elements;
        this.foregroundColorForRelevantElements = foregroundColorForReferencingElements;
    }

    public EObjectNavigatorDialog(List<? extends EObject> elements, String dialogTitle, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int foregroundColorForReferencingElements) {
        this(elements, dialogTitle, dialogMessage, QuickfixMessages.eobjectnavigator_dialog_combo_lbl, QuickfixMessages.eobjectnavigator_dialog_combo_element_prefix, dialogImageType, dialogButtonLabels, foregroundColorForReferencingElements);
    }

    protected Control createCustomArea(Composite parent) {
        Composite containingComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        containingComposite.setLayout((Layout)layout);
        containingComposite.setLayoutData((Object)new GridData(1808));
        this.createSelectCycleArea(containingComposite);
        this.createViewerArea(containingComposite);
        return containingComposite;
    }

    protected void createSelectCycleArea(Composite parent) {
        boolean initialSelection = false;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        Label lbl = new Label(comp, 0);
        lbl.setText(this.comboLabel);
        this.combo = new Combo(comp, 2078);
        GridData gd = new GridData(4, 4, true, true);
        this.combo.setLayoutData((Object)gd);
        this.combo.setData(String.valueOf(0), this.revelantElements);
        Iterator<List<EObject>> it = this.cycles.iterator();
        int i = 0;
        while (i < this.cycles.size()) {
            this.combo.add(String.valueOf(this.elementPrefix) + ' ' + (i + 1));
            this.combo.setData(String.valueOf(i), it.next());
            ++i;
        }
        this.combo.select(0);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = EObjectNavigatorDialog.this.combo.getSelectionIndex();
                List list = (List)EObjectNavigatorDialog.this.combo.getData(String.valueOf(idx));
                EObjectNavigatorDialog.this.getViewer().setInput((Object)new TreeData((Collection)list, null));
            }
        });
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(parent, false, 2){

            protected void createControl(Composite parent_) {
                super.createControl(parent_);
            }
        };
        if (this._contextMenuManagerFiller != null) {
            treeViewer.setContextMenuManagerFiller(this._contextMenuManagerFiller);
        }
        TreeViewer viewer = treeViewer.getClientViewer();
        viewer.setContentProvider((IContentProvider)new DataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ImpactAnalysisLabelProvider(viewer, this.foregroundColorForRelevantElements));
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setSorter((ViewerSorter)new ImpactAnalysisSorter());
        return viewer;
    }

    protected TreeData getInitialInputData() {
        return new TreeData(this.revelantElements, null);
    }

    public void setContextMenuManagerFiller(AbstractContextMenuFiller filler) {
        this._contextMenuManagerFiller = filler;
    }

    protected class ImpactAnalysisLabelProvider
    extends MDEAdapterFactoryLabelProvider
    implements IColorProvider {
        private int foregroundColor;
        private TreeViewer viewer;

        public ImpactAnalysisLabelProvider(TreeViewer viewer, int foregroundColorForReferencingElements) {
            super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
            this.foregroundColor = foregroundColorForReferencingElements;
            this.viewer = viewer;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Object input = this.viewer.getInput();
            if (input instanceof TreeData && ((TreeData)input).isValid(element)) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                return display.getSystemColor(this.foregroundColor);
            }
            return null;
        }

        public String getText(Object object) {
            String text = super.getText(object);
            return text.replace("%20", " ");
        }
    }

    protected class ImpactAnalysisSorter
    extends ViewerSorter {
        public ImpactAnalysisSorter() {
        }

        public ImpactAnalysisSorter(Collator collator) {
            super(collator);
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            if (object1 instanceof Resource && object2 instanceof Resource) {
                Resource resource1 = (Resource)object1;
                Resource resource2 = (Resource)object2;
                if (CapellaResourceHelper.isCapellaResource((Resource)resource1) && CapellaResourceHelper.isCapellaResource((Resource)resource2)) {
                    int result = 0;
                    boolean fragment1 = CapellaResourceHelper.isCapellaFragment((URI)resource1.getURI());
                    boolean fragment2 = CapellaResourceHelper.isCapellaFragment((URI)resource2.getURI());
                    if (fragment1 && !fragment2) {
                        result = 1;
                    } else if (!fragment1 && fragment2) {
                        result = -1;
                    }
                    return result;
                }
            }
            return super.compare(viewer, object1, object2);
        }
    }
}

