/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.platform.sirius.clipboard.Messages;
import org.polarsys.capella.core.platform.sirius.clipboard.actions.AbstractCopyPasteAction;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.CapellaDiagramPasteCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.GraphicalAdjustmentCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.util.CapellaDiagramClipboard;
import org.polarsys.capella.core.platform.sirius.clipboard.util.GmfUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.SiriusUtil;

public class CapellaDiagramPasteAction
extends AbstractCopyPasteAction {
    private Point _cursorLocation = null;

    public void run(IAction action_p) {
        Text currentEditingText = this.getEditingTextWidget();
        WrappingLabel selectedNoteContent = this.getSelectedNoteContentFigure();
        if (currentEditingText != null) {
            currentEditingText.paste();
        } else if (selectedNoteContent != null) {
            String toPaste = this.getTextFromSystemClipboard();
            if (toPaste != null) {
                selectedNoteContent.setText(toPaste);
            }
        } else {
            this.pasteElements();
        }
    }

    private void pasteElements() {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                CapellaDiagramPasteAction.this.doRun(monitor_p);
            }
        };
        try {
            progressDialog.run(false, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    void doRun(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.CapellaDiagramPasteAction_ProgressMessage, 2);
            final List<? extends View> gmfSelection = this.getCopyPasteSelection();
            monitor.worked(1);
            final CapellaDiagramPasteCommand siriusCmd = new CapellaDiagramPasteCommand(gmfSelection, true);
            boolean success = MiscUtil.transactionallyExecute(gmfSelection, (ICommand)siriusCmd);
            monitor.worked(1);
            if (success) {
                final Point relativeLocation = this.getRelativeLocation();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        View target = siriusCmd.getGmfTarget();
                        DSemanticDecorator siriusTarget = LayerUtil.getSiriusElement(target);
                        GraphicalAdjustmentCommand gmfCmd = SiriusUtil.layoutIsConstrained((EObject)siriusTarget) && CapellaDiagramPasteAction.this.mustRefresh() ? new GraphicalAdjustmentCommand(target) : new GraphicalAdjustmentCommand(siriusCmd.getResults(), siriusCmd.getPastedSiriusElementsOrigins(), target, relativeLocation, CapellaDiagramPasteAction.this.mustRefresh(), CapellaDiagramPasteAction.this.mustPasteLayout(), CapellaDiagramPasteAction.this.mustPasteStyle());
                        MiscUtil.transactionallyExecute(gmfSelection, (ICommand)gmfCmd);
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
    }

    private Point getRelativeLocation() {
        Point result = null;
        EditPart target = this.getSelection().get(0);
        if (target instanceof GraphicalEditPart) {
            result = GmfUtil.getEditPartRelativeLocation(this._cursorLocation, (GraphicalEditPart)target);
        }
        return result;
    }

    @Override
    protected boolean isEnabled() {
        boolean result = this.isInLabelEdition() ? true : (this.isOnNoteContent() ? this.getTextFromSystemClipboard() != null : !this.isInSequenceDiagram() && !CapellaDiagramClipboard.getInstance().isEmpty());
        return result;
    }

    protected boolean mustRefresh() {
        return true;
    }

    @Override
    public void selectionChanged(IAction action_p, ISelection selection_p) {
        super.selectionChanged(action_p, selection_p);
        if (this.getShell() != null) {
            this._cursorLocation = this.getShell().getDisplay().getCursorLocation();
        }
    }

    public boolean mustPasteLayout() {
        return true;
    }

    public boolean mustPasteStyle() {
        return true;
    }
}

