/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Point;
import org.polarsys.capella.core.platform.sirius.clipboard.Messages;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.AbstractResultCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.util.CapellaDiagramClipboard;
import org.polarsys.capella.core.platform.sirius.clipboard.util.GmfUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.SiriusUtil;

public class GraphicalAdjustmentCommand
extends AbstractResultCommand {
    private List<DSemanticDecorator> _pastedSiriusElements;
    private Map<? extends DSemanticDecorator, ? extends DSemanticDecorator> _originsMapping;
    private View _targetView;
    private Point _relativeLocation;
    private final PinHelper _pinHelper;
    private boolean _mustRefresh;
    private final boolean applyLayout;
    private final boolean applyStyle;

    public GraphicalAdjustmentCommand(List<? extends EObject> targets, Map<? extends DSemanticDecorator, ? extends DSemanticDecorator> origins, View targetView, Point newLocation, boolean mustRefresh, boolean applyLayout, boolean applyStyle) {
        assert (origins != null);
        assert (targets != null);
        this._originsMapping = origins;
        this._pastedSiriusElements = MiscUtil.filter(targets, DSemanticDecorator.class);
        this._targetView = targetView;
        this._relativeLocation = newLocation;
        this._mustRefresh = mustRefresh;
        this._pinHelper = new PinHelper();
        this.applyLayout = applyLayout;
        this.applyStyle = applyStyle;
    }

    public GraphicalAdjustmentCommand(View targetView) {
        this._originsMapping = Collections.emptyMap();
        this._pastedSiriusElements = Collections.emptyList();
        this._targetView = targetView;
        this._relativeLocation = null;
        this._mustRefresh = true;
        this._pinHelper = new PinHelper();
        this.applyLayout = false;
        this.applyStyle = false;
    }

    public void run() {
        List<Object> gmfRoots;
        if (this._pastedSiriusElements != null && !this._pastedSiriusElements.isEmpty()) {
            List<DSemanticDecorator> siriusRoots = MiscUtil.getRoots(this._pastedSiriusElements);
            for (DSemanticDecorator target : siriusRoots) {
                IGraphicalEditPart pastedGraphicalEditPart = LayerUtil.getGraphicalPart(target);
                if (pastedGraphicalEditPart == null) continue;
                CapellaDiagramClipboard.getInstance().applyFormat(this._originsMapping, pastedGraphicalEditPart, this.applyLayout, this.applyStyle);
            }
            gmfRoots = MiscUtil.filter(LayerUtil.upToGmf(siriusRoots), Node.class);
            if (this._relativeLocation != null && !(this._targetView instanceof Edge)) {
                this.moveAll(gmfRoots, this._targetView, this._relativeLocation);
            }
        } else {
            gmfRoots = Collections.emptyList();
        }
        if (this._mustRefresh) {
            this.refresh(gmfRoots);
        }
    }

    protected void refresh(Collection<? extends Node> roots) {
        Diagram gmfDiag;
        EObject diagElement;
        DDiagram diagram = null;
        if (!this._pastedSiriusElements.isEmpty()) {
            diagram = SiriusUtil.getOwningDiagram((EObject)this._pastedSiriusElements.get(0));
        } else if (this._targetView != null && (diagElement = (gmfDiag = this._targetView.getDiagram()).getElement()) instanceof DDiagram) {
            diagram = (DDiagram)diagElement;
        }
        if (diagram != null) {
            diagram.refresh();
        }
    }

    protected void moveAll(Collection<? extends Node> roots, View targetView, Point relativeLocation) {
        Point absoluteNewLocation;
        if (roots.isEmpty()) {
            return;
        }
        if (targetView instanceof Diagram) {
            absoluteNewLocation = relativeLocation;
        } else {
            Point targetViewLocation = GmfUtil.getAbsoluteLocation((Node)targetView);
            absoluteNewLocation = new Point(targetViewLocation.x + relativeLocation.x, targetViewLocation.y + relativeLocation.y);
        }
        Point absoluteCurrentLocation = GmfUtil.getAbsoluteTopLeftCorner(roots);
        Point vector = new Point(absoluteNewLocation.x - absoluteCurrentLocation.x, absoluteNewLocation.y - absoluteCurrentLocation.y);
        for (Node node : roots) {
            this.move(node, vector);
        }
    }

    protected void move(Node node, Point vector) {
        LayoutConstraint layout = node.getLayoutConstraint();
        if (layout instanceof Location) {
            Location location = (Location)layout;
            location.setX(location.getX() + vector.x);
            location.setY(location.getY() + vector.y);
            this.pin(node.getElement());
        }
    }

    protected void pin(Object object) {
        if (object instanceof DDiagramElement) {
            this._pinHelper.markAsPinned((DDiagramElement)object);
        }
    }

    public String getName() {
        return Messages.GraphicalAdjustmentCommand_Name;
    }
}

