/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetricTree<T> {
    private MetricTree<T> _parent = null;
    private List<MetricTree<T>> _children = null;
    private T _nodeId;
    private Integer _data;

    public T getId() {
        return this._nodeId;
    }

    public Integer getData() {
        return this._data;
    }

    public void setData(Integer value_p) {
        this._data = value_p;
    }

    public boolean hasData() {
        return this._data != null;
    }

    public MetricTree<T> getParent() {
        return this._parent;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public List<MetricTree<T>> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    public void addChild(MetricTree<T> child_p) {
        this.addChildren(Collections.singletonList(child_p));
    }

    public void addChildren(List<MetricTree<T>> children_p) {
        if (!this.hasChildren()) {
            this._children = new ArrayList<MetricTree<T>>();
        }
        this._children.addAll(children_p);
    }

    public MetricTree(T id, Integer data, MetricTree<T> parent) {
        this._parent = parent;
        this._nodeId = id;
        this._data = data;
    }

    public void clear() {
        this._parent = null;
        this._nodeId = null;
        this._data = null;
        if (this.getChildren() != null) {
            for (MetricTree<T> current : this.getChildren()) {
                current.clear();
            }
            this._children.clear();
        }
    }
}

