/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.customisation.resourcelocator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

public class SiriusResourceLocator
implements ResourceLocator {
    private static final String DOT = ".";
    private static final URI DOT_URI = URI.createURI((String)".");
    private static final String PLUGIN_PROPERTIES_FILE = "plugin.properties";
    protected URL baseURL;
    protected ResourceBundle untranslatedResourceBundle;
    protected ResourceBundle resourceBundle;
    protected boolean shouldTranslate = true;
    protected Map<String, String> strings = new HashMap<String, String>();
    protected Map<String, String> untranslatedStrings = new HashMap<String, String>();

    public URL getBaseURL() {
        block13: {
            if (this.baseURL == null) {
                try {
                    Class<?> theClass = this.getClass();
                    URL pluginPropertiesURL = theClass.getResource(PLUGIN_PROPERTIES_FILE);
                    if (pluginPropertiesURL == null) {
                        String className = theClass.getName();
                        int index = className.lastIndexOf(DOT);
                        URL classURL = theClass.getResource(String.valueOf(index == -1 ? className : className.substring(index + 1)) + ".class");
                        URI uri = URI.createURI((String)classURL.toString());
                        int count = 1;
                        int i = 0;
                        while ((i = className.indexOf(46, i)) != -1) {
                            ++count;
                            ++i;
                        }
                        if (URI.isArchiveScheme((String)(uri = uri.trimSegments(count)).scheme())) {
                            try {
                                InputStream inputStream = new URL(uri.appendSegment(PLUGIN_PROPERTIES_FILE).toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(uri.toString());
                            }
                            catch (IOException exception) {
                                uri = URI.createURI((String)uri.authority()).trimSegments(1);
                            }
                        }
                        if (this.baseURL == null) {
                            String lastSegment = uri.lastSegment();
                            if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                                uri = uri.trimSegments(1);
                            }
                            uri = uri.appendSegment(PLUGIN_PROPERTIES_FILE);
                            try {
                                InputStream inputStream = new URL(uri.toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(DOT_URI.resolve(uri).toString());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (this.baseURL == null) {
                            String resourceName = index == -1 ? PLUGIN_PROPERTIES_FILE : String.valueOf(className.substring(0, index + 1).replace('.', '/')) + PLUGIN_PROPERTIES_FILE;
                            throw new MissingResourceException("Missing properties: " + resourceName, theClass.getName(), PLUGIN_PROPERTIES_FILE);
                        }
                        break block13;
                    }
                    this.baseURL = new URL(DOT_URI.resolve(URI.createURI((String)pluginPropertiesURL.toString())).toString());
                }
                catch (IOException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
        }
        return this.baseURL;
    }

    public Object getImage(String key) {
        throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_ImageResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
    }

    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    public String getString(String key, boolean translate) {
        Map<String, String> stringMap = translate ? this.strings : this.untranslatedStrings;
        String result = stringMap.get(key);
        if (result == null) {
            result = this.doGetString(key, translate);
            stringMap.put(key, result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doGetString(String key, boolean translate) throws MissingResourceException {
        ResourceBundle bundle;
        ResourceBundle resourceBundle = bundle = translate ? this.resourceBundle : this.untranslatedResourceBundle;
        if (bundle != null) return bundle.getString(key);
        String packageName = this.getClass().getName();
        int index = packageName.lastIndexOf(DOT);
        if (index != -1) {
            packageName = packageName.substring(0, index);
        }
        if (translate) {
            try {
                bundle = this.resourceBundle = ResourceBundle.getBundle(String.valueOf(packageName) + ".plugin");
                return bundle.getString(key);
            }
            catch (MissingResourceException exception) {
                try {
                    InputStream inputStream = new URL(String.valueOf(this.getBaseURL().toString()) + PLUGIN_PROPERTIES_FILE).openStream();
                    bundle = this.untranslatedResourceBundle = (this.resourceBundle = new PropertyResourceBundle(inputStream));
                    inputStream.close();
                }
                catch (IOException inputStream) {
                    // empty catch block
                }
                if (bundle != null) return bundle.getString(key);
                throw exception;
            }
        }
        String resourceName = String.valueOf(this.getBaseURL().toString()) + PLUGIN_PROPERTIES_FILE;
        try {
            InputStream inputStream = new URL(resourceName).openStream();
            bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
            inputStream.close();
            return bundle.getString(key);
        }
        catch (IOException ioException) {
            throw new MissingResourceException("Missing properties: " + resourceName, this.getClass().getName(), PLUGIN_PROPERTIES_FILE);
        }
    }

    public String getString(String key, Object[] substitutions) {
        return this.getString(key, substitutions, this.shouldTranslate());
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return MessageFormat.format(this.getString(key, translate), substitutions);
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }
}

