/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.core.sirius.ui.Messages;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.closeproject.SessionCloseManager;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CloseSessionAction
extends BaseSelectionListenerAction {
    private boolean showDialog;
    private boolean shouldSaveIfNoDialog;

    public CloseSessionAction() {
        super(Messages.CloseSessionAction_Title);
        this.setActionDefinitionId("org.eclipse.ui.file.close");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/close.gif"));
        this.showDialog = true;
    }

    public void showDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public void shouldSaveIfNoDialog(boolean save) {
        this.shouldSaveIfNoDialog = save;
    }

    public void run() {
        List<Session> sessions = this.getSessionsFromSelection(this.getStructuredSelection());
        CloseSessionOperation closeSessionOperation = new CloseSessionOperation(sessions);
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        SiriusUIPlugin.getDefault().runSaveOperation(activeShell, closeSessionOperation);
    }

    private List<Session> getSessionsFromSelection(IStructuredSelection selection) {
        ArrayList<Session> sessions = new ArrayList<Session>(0);
        for (Object selectedElement : selection) {
            Session session;
            if (selectedElement instanceof Session) {
                sessions.add((Session)selectedElement);
                continue;
            }
            if (!(selectedElement instanceof IFile) || (session = SessionHelper.getSessionForDiagramFile((IFile)selectedElement)) == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterator<Session> sessions = this.getSessionsFromSelection(selection).iterator();
        boolean isOneSessionClosed = false;
        while (sessions.hasNext() && !isOneSessionClosed) {
            Session selectedSession = sessions.next();
            boolean bl = isOneSessionClosed = !selectedSession.isOpen();
        }
        return !isOneSessionClosed;
    }

    private class CloseOthersEditorRunnable
    implements Runnable {
        private boolean save;
        private Session currentSession;

        public CloseOthersEditorRunnable(Session session, boolean save) {
            this.currentSession = session;
            this.save = save;
        }

        @Override
        public void run() {
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page == null) {
                return;
            }
            IEditorReference[] editorReferences = page.getEditorReferences();
            ArrayList<IEditorReference> editorReferencesToClose = new ArrayList<IEditorReference>(0);
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        IEditorInput editorReferenceInput = editorReference.getEditorInput();
                        if (!(editorReferenceInput instanceof URIEditorInput) || !(this.currentSession instanceof DAnalysisSession)) break block6;
                        Collection<Resource> analysisResources = SessionHelper.getAllAirdResources(this.currentSession);
                        for (Resource resource : analysisResources) {
                            URI uri = resource.getURI();
                            URI trimFragment = ((URIEditorInput)editorReferenceInput).getURI().trimFragment();
                            if (uri == null || !uri.equals(trimFragment)) continue;
                            editorReferencesToClose.add(editorReference);
                            break;
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (!editorReferencesToClose.isEmpty()) {
                page.closeEditors(editorReferencesToClose.toArray(new IEditorReference[editorReferencesToClose.size()]), this.save);
            }
        }
    }

    private class CloseSessionCommand
    extends AbstractNonDirtyingCommand {
        private Session session;

        public CloseSessionCommand(Session session) {
            this.session = session;
        }

        protected void saveSession(Session session) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            if (SessionCloseManager.isSaveable(session, files)) {
                SessionCloseManager.saveSession(session);
            } else {
                String msg = Messages.unableToSaveDialog_TopMsg;
                for (IFile file : files) {
                    msg = String.valueOf(msg) + file.toString() + '\n';
                }
                msg = String.valueOf(msg) + '\n' + Messages.unableToSaveDuringCloseOpsDialog_BottomQuestion + '\n';
                Shell activeShell = Display.getCurrent().getActiveShell();
                MessageDialog.openQuestion((Shell)activeShell, (String)Messages.CloseSessionAction_Title, (String)msg);
            }
        }

        protected void closeSession(Session session, boolean saveIsNeeded) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (uiSession != null) {
                SessionCloseManager.closeUISession(uiSession, saveIsNeeded);
            }
            Display.getDefault().syncExec((Runnable)new CloseOthersEditorRunnable(session, saveIsNeeded));
            if (uiSession != null) {
                SessionCloseManager.removeUiSession(uiSession);
            }
            if (session.isOpen()) {
                SessionCloseManager.closeSession(session);
            }
        }

        public void run() {
            boolean saveIsNeeded;
            int choice = 1;
            if (SessionCloseManager.isDirty(this.session)) {
                if (CloseSessionAction.this.showDialog) {
                    choice = SWTUtil.showSaveDialog((Object)this.session, (String)"Session", (boolean)true);
                } else {
                    int n = choice = CloseSessionAction.this.shouldSaveIfNoDialog ? 0 : 1;
                }
            }
            if (2 == choice) {
                return;
            }
            boolean bl = saveIsNeeded = choice == 0;
            if (saveIsNeeded) {
                this.saveSession(this.session);
            }
            this.closeSession(this.session, saveIsNeeded);
        }
    }

    public class CloseSessionOperation
    implements IRunnableWithProgress {
        private List<Session> selectedSessions;

        public CloseSessionOperation(List<Session> selectedSessions) {
            this.selectedSessions = selectedSessions;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            for (Session session : this.selectedSessions) {
                CloseSessionCommand command = new CloseSessionCommand(session);
                command.run();
            }
        }
    }
}

