/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.sirius.ui.wizard.AirdFileCreationWizardPage;

public class ExtractRepresentationsWizard
extends Wizard {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private TransactionalEditingDomain _domain;
    private DAnalysisSession _session;
    private List<DRepresentation> _representations;
    private AirdFileCreationWizardPage _diagramModelFilePage;
    private Resource _pickedResource;

    public ExtractRepresentationsWizard(DAnalysisSession session_p, TransactionalEditingDomain domain_p, List<DRepresentation> movableRepresentations_p) {
        this._domain = domain_p;
        this._session = session_p;
        this._representations = movableRepresentations_p;
    }

    public void init(IWorkbench workbench_p, IStructuredSelection selection_p) {
        this.setWindowTitle("Extract views");
        this.setNeedsProgressMonitor(true);
    }

    protected TransactionalEditingDomain getDomain() {
        return this._domain;
    }

    public boolean performFinish() {
        this.closeRepresentations(this._representations);
        DiagramFileCreationOperation op = new DiagramFileCreationOperation();
        boolean errorCatch = false;
        errorCatch = this.createAIRDFile((IRunnableWithProgress)op, errorCatch);
        if (errorCatch) {
            return false;
        }
        DAnalysis slaveAnalysis = this.prepareNewAnalysis();
        this.moveRepresentations(slaveAnalysis);
        return true;
    }

    private void moveRepresentations(final DAnalysis slaveAnalysis_p) {
        IRunnableWithProgress moveReps = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor_p) {
                ExtractRepresentationsWizard.this.getDomain().getCommandStack().execute((Command)new RecordingCommand(ExtractRepresentationsWizard.this.getDomain()){

                    protected void doExecute() {
                        ExtractRepresentationsWizard.this.doMoveRepresentation(slaveAnalysis_p);
                    }

                    public boolean canUndo() {
                        return false;
                    }
                });
            }
        };
        try {
            this.getContainer().run(false, true, moveReps);
        }
        catch (InterruptedException ex_p) {
            __logger.debug((Object)new EmbeddedMessage(ex_p.getMessage(), "User Interface"));
        }
        catch (InvocationTargetException ex_p) {
            __logger.debug((Object)new EmbeddedMessage(ex_p.getMessage(), "User Interface"));
        }
    }

    private boolean createAIRDFile(IRunnableWithProgress op_p, boolean error_p) {
        boolean errorCatch = error_p;
        try {
            this.getContainer().run(false, true, op_p);
        }
        catch (InterruptedException e) {
            errorCatch = true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                CoreException targetException = (CoreException)e.getTargetException();
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error creating resource", null, (IStatus)targetException.getStatus());
            } else {
                SiriusTransPlugin.getPlugin().error("Error creating aird session data", e.getTargetException());
            }
            errorCatch = true;
        }
        return errorCatch;
    }

    private DAnalysis prepareNewAnalysis() {
        final DAnalysis slaveAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

            protected void doExecute() {
                ExtractRepresentationsWizard.this.doPrepareNewAnalysis(slaveAnalysis);
            }

            public boolean canUndo() {
                return false;
            }
        });
        return slaveAnalysis;
    }

    private void closeRepresentations(List<DRepresentation> diagrams_p) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession((Session)this._session);
        if (uiSession != null) {
            for (DRepresentation representation : diagrams_p) {
                this.closeOpenedEditor(uiSession, representation);
            }
        }
    }

    private void closeOpenedEditor(IEditingSession uiSession_p, DRepresentation representation_p) {
        DialectEditor editor = uiSession_p.getEditor(representation_p);
        if (editor != null) {
            editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
        }
    }

    public void addPages() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("odesign");
        this._diagramModelFilePage = new AirdFileCreationWizardPage("DiagramModelFile", (IStructuredSelection)new StructuredSelection(), "aird");
        this.addPage((IWizardPage)this._diagramModelFilePage);
    }

    public Resource getCreatedResource() {
        return this._pickedResource;
    }

    protected void doMoveRepresentation(DAnalysis slaveAnalysis_p) {
        this._session.addReferencedAnalysis(slaveAnalysis_p);
        for (Resource resource : this._session.getSemanticResources()) {
            if (resource.getContents().isEmpty()) continue;
            slaveAnalysis_p.getSemanticResources().add((Object)new ResourceDescriptor(resource.getURI()));
        }
        for (DRepresentation representation : this._representations) {
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor();
            if (representationDescriptor == null) continue;
            this._session.moveRepresentation(slaveAnalysis_p, representationDescriptor);
        }
    }

    protected void doCreateResource() {
        this._pickedResource = TransactionHelper.getEditingDomain((Session)this._session).getResourceSet().createResource(this._diagramModelFilePage.getURI());
    }

    protected void doPrepareNewAnalysis(DAnalysis slaveAnalysis) {
        this._pickedResource.getContents().add((Object)slaveAnalysis);
    }

    private class DiagramFileCreationOperation
    extends WorkspaceModifyOperation {
        public DiagramFileCreationOperation() {
            super(null);
        }

        protected void execute(IProgressMonitor monitor_p) throws CoreException, InterruptedException {
            ExtractRepresentationsWizard.this.doCreateResource();
        }
    }
}

