/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractSideRelatedDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class ThreeWayMoveCategory
extends AbstractSideRelatedDifferenceCategory {
    public static final String ID_LEFT = "Technical.3WayMove.Left";
    public static final String ID_RIGHT = "Technical.3WayMove.Right";

    public ThreeWayMoveCategory(boolean sideIsLeft_p) {
        super(sideIsLeft_p);
    }

    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (node_p.isThreeWay() && node_p.getCategoryManager().isMove(difference_p)) {
            Role sideRole = node_p.getRoleForSide(this.isLeftSide());
            result = ((IPresenceDifference)difference_p).getPresenceRole() == sideRole && !difference_p.isAlignedWithAncestor();
        }
        return result;
    }

    public String getID() {
        return this.isLeftSide() ? ID_LEFT : ID_RIGHT;
    }

    public Image getImage(EMFDiffNode node_p) {
        return EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.TREE);
    }

    public String getText(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.ThreeWayMoveCategory_TextMovedLeft : Messages.ThreeWayMoveCategory_TextMovedRight;
        return result;
    }

    public boolean isApplicable(EMFDiffNode node_p) {
        return node_p.isThreeWay();
    }
}

