/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.properties.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.core.properties.Messages;
import org.polarsys.capella.core.data.core.properties.controllers.GeneralizableElementController;
import org.polarsys.capella.core.data.core.properties.fields.GeneralizableElementBooleanPropertiesCheckbox;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.CompositionMultipleSemanticField;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public abstract class GeneralizableElementSection
extends NamedElementSection {
    private boolean showIsAbstract;
    private boolean showSuperTypes;
    private CompositionMultipleSemanticField superTypes;
    private GeneralizableElementBooleanPropertiesCheckbox propertiesCheckbox;

    public GeneralizableElementSection() {
        this(true, true);
    }

    public GeneralizableElementSection(boolean showSuperTypes, boolean showIsAbstract) {
        this.showSuperTypes = showSuperTypes;
        this.showIsAbstract = showIsAbstract;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        if (this.showIsAbstract) {
            Group checkGroup = this.getWidgetFactory().createGroup(this._rootParentComposite, "");
            checkGroup.setLayout((Layout)new GridLayout(5, true));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            checkGroup.setLayoutData((Object)gd);
            this.propertiesCheckbox = new GeneralizableElementBooleanPropertiesCheckbox((Composite)checkGroup, this.getWidgetFactory());
            this.propertiesCheckbox.setDisplayedInWizard(displayedInWizard);
        }
        if (this.showSuperTypes) {
            this.superTypes = new CompositionMultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("GeneralizableElementSection_SuperType_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new GeneralizableElementController()){

                protected List<EObject> openTransferDialog(Button button, List<EObject> currentElements, List<EObject> availableElements, String title, String message) {
                    if (CapellaModelPreferencesPlugin.getDefault().isMultipleInheritanceAllowed()) {
                        return super.openTransferDialog(button, currentElements, availableElements, title, message);
                    }
                    EObject firstResult = SelectionDialogHelper.simplePropertySelectionDialogWizard(availableElements, (Shell)button.getShell());
                    if (firstResult != null) {
                        return Collections.singletonList(firstResult);
                    }
                    return null;
                }
            };
            this.superTypes.setDisplayedInWizard(displayedInWizard);
        }
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        if (this.propertiesCheckbox != null) {
            this.propertiesCheckbox.loadData(capellaElement);
        }
        if (this.superTypes != null) {
            this.superTypes.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getGeneralizableElement_Super(), (EStructuralFeature)CapellacorePackage.eINSTANCE.getGeneralizableElement_OwnedGeneralizations());
        }
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.propertiesCheckbox);
        fields.add((AbstractSemanticField)this.superTypes);
        return fields;
    }
}

