/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.control;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.control.SiriusControlCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.util.EMFCoreUtil;
import org.eclipse.sirius.ui.tools.internal.wizards.SelectRepresentationsWizard;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class SiriusControlHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final EObject semanticRoot = this.getSelectedEObject(event);
        if (semanticRoot != null) {
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.SiriusControlHandler_controlTask, 1);
                            SiriusControlHandler.this.performControl(HandlerUtil.getActiveShell((ExecutionEvent)event), semanticRoot, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return null;
    }

    public void performControl(Shell shell, EObject semanticRoot, IProgressMonitor monitor) {
        URI semanticDest;
        Session session = SessionManager.INSTANCE.getSession(semanticRoot);
        if (session != null && (semanticDest = this.getControledResourceURI(shell, semanticRoot)) != null) {
            try {
                HashSet representationDescriptors = Sets.newHashSet(this.getRepresentationDescriptorsToMove(shell, session, semanticRoot));
                URI representationDest = this.getDefaultCorrespondingAird(semanticDest);
                SiriusControlCommand vcc = new SiriusControlCommand(semanticRoot, semanticDest, (Set)representationDescriptors, representationDest, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                TransactionUtil.getEditingDomain((EObject)semanticRoot).getCommandStack().execute((Command)vcc);
                session.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
                for (DRepresentationDescriptor dRepDescriptor : representationDescriptors) {
                    DialectEditor editor = uiSession.getEditor(dRepDescriptor.getRepresentation());
                    if (!(editor instanceof IReusableEditor)) continue;
                    IReusableEditor iReusableEditor = (IReusableEditor)editor;
                    SessionEditorInput updatedEditorInput = new SessionEditorInput(EcoreUtil.getURI((EObject)dRepDescriptor.getRepresentation()), dRepDescriptor.getRepresentation().getName(), session);
                    iReusableEditor.setInput((IEditorInput)updatedEditorInput);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected URI getControledResourceURI(Shell shell, EObject semanticRoot) {
        List uris;
        String defaultURI = this.getDefaultControlURI(semanticRoot);
        ResourceDialog dlg = this.createControlResourceDialog(shell, defaultURI);
        if (dlg.open() == 0 && !(uris = dlg.getURIs()).isEmpty()) {
            return (URI)uris.get(0);
        }
        return null;
    }

    protected ResourceDialog createControlResourceDialog(Shell shell, String defaultURI) {
        return new ControlResourceDialog(shell, defaultURI);
    }

    private EObject getSelectedEObject(ExecutionEvent event) {
        IStructuredSelection iss;
        Object obj;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (obj = (iss = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }

    protected URI getDefaultCorrespondingAird(URI semanticModelUri) {
        return semanticModelUri.trimFileExtension().appendFileExtension("aird");
    }

    protected Collection<DRepresentationDescriptor> getRepresentationDescriptorsToMove(Shell shell, Session session, EObject semanticRoot) throws InterruptedException {
        Collection<DRepresentationDescriptor> representations = this.collectExistingRepresentationDescriptors(session, semanticRoot);
        Collection<DRepresentationDescriptor> representationsToMove = this.askUserWhichRepresentationToSplit(shell, session, representations);
        return representationsToMove;
    }

    protected Collection<DRepresentationDescriptor> askUserWhichRepresentationToSplit(Shell shell, Session session, Collection<DRepresentationDescriptor> preselection) throws InterruptedException {
        if (!DialectManager.INSTANCE.getAllRepresentationDescriptors(session).isEmpty()) {
            SelectRepresentationsWizard wizard = new SelectRepresentationsWizard(session, preselection);
            wizard.init();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.setHelpAvailable(false);
            dialog.create();
            if (dialog.open() == 0) {
                return wizard.getSelectedRepresentations();
            }
            throw new InterruptedException();
        }
        return Collections.emptySet();
    }

    protected Collection<DRepresentationDescriptor> collectExistingRepresentationDescriptors(Session session, EObject semanticRoot) {
        ArrayList<DRepresentationDescriptor> result = new ArrayList<DRepresentationDescriptor>();
        result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(semanticRoot, session));
        TreeIterator it = EcoreUtil.getAllProperContents((EObject)semanticRoot, (boolean)true);
        while (it.hasNext()) {
            EObject root = (EObject)it.next();
            result.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(root, session));
        }
        return result;
    }

    protected String getDefaultControlURI(EObject obj) {
        StringBuilder uri = new StringBuilder();
        URI objResourceURI = obj.eResource().getURI();
        uri.append(URI.decode((String)objResourceURI.trimFileExtension().toString()));
        uri.append("_");
        uri.append(EMFCoreUtil.getName(obj));
        uri.append(".");
        uri.append(objResourceURI.fileExtension());
        return uri.toString();
    }

    private class ControlResourceDialog
    extends ResourceDialog {
        private final String defaultURI;

        public ControlResourceDialog(Shell parent, String defaultURI) {
            super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_ControlDialog_title"), 8192);
            this.defaultURI = defaultURI;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.uriField.setText(URI.encodeFragment((String)this.defaultURI, (boolean)true));
            return control;
        }
    }
}

