/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class OpenRepresentationListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        List selection;
        Iterable<DRepresentationDescriptor> repDescriptorToOpen;
        if (event != null && event.getSelection() instanceof IStructuredSelection && !Iterables.isEmpty(repDescriptorToOpen = this.getRepresentationDescriptorsToOpen(selection = ((IStructuredSelection)event.getSelection()).toList()))) {
            new OpenRepresentationsAction(Sets.newLinkedHashSet(repDescriptorToOpen)).run();
        }
    }

    private Iterable<DRepresentationDescriptor> getRepresentationDescriptorsToOpen(List<?> selection) {
        LinkedHashSet repDescriptors = Sets.newLinkedHashSet();
        for (Object obj : selection) {
            if (obj instanceof DRepresentationDescriptor) {
                repDescriptors.add((DRepresentationDescriptor)obj);
                continue;
            }
            DRepresentationDescriptor adapted = this.adaptToDRepresentationDescriptor(obj);
            if (adapted == null) continue;
            repDescriptors.add(adapted);
        }
        return repDescriptors;
    }

    private DRepresentationDescriptor adaptToDRepresentationDescriptor(Object input) {
        Object adapter;
        if (input instanceof IAdaptable && (adapter = ((IAdaptable)input).getAdapter(EObject.class)) instanceof DRepresentationDescriptor) {
            return (DRepresentationDescriptor)adapter;
        }
        return null;
    }
}

