/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.ui.view;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.polarsys.capella.common.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.common.command.recorder.ui.view.AbstractRecorderView;

public class ImportRecordAction
extends Action
implements IMenuCreator {
    private final AbstractRecorderView _recorderView;
    private Menu _toolbarMenu = null;
    private Collection<Action> _actions;
    private File _selected = null;

    public ImportRecordAction(AbstractRecorderView recordView, String text) {
        super(text);
        this._recorderView = recordView;
        this._actions = new HashSet<Action>();
        this.setMenuCreator(this);
    }

    public void run() {
        String path = this._recorderView.selectRecord();
        if (path != null) {
            this._selected = new Path(path).toFile();
        }
    }

    public Menu getMenu(Control parent) {
        if (this._toolbarMenu != null) {
            this.dispose();
        }
        this._toolbarMenu = new Menu(parent);
        this.createMenuItems(this._toolbarMenu);
        return this._toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void createMenuItems(Menu menu) {
        this._actions.clear();
        File root = OutputHelper.getRootDirectoryForStorage();
        List subdirectory = OutputHelper.getDirectSubDirectory((File)root);
        for (File dir : subdirectory) {
            List files = OutputHelper.getRecordFiles((File)dir);
            RecordAction action = null;
            if (files.isEmpty()) continue;
            MenuManager subMenu = new MenuManager(dir.getName());
            subMenu.fill(menu, -1);
            for (File file : files) {
                action = new RecordAction(file);
                subMenu.add((IAction)action);
                if (this._selected == null || !this._selected.equals(file)) continue;
                action.setChecked(true);
            }
        }
    }

    public void dispose() {
        if (this._toolbarMenu != null) {
            MenuItem[] items = this._toolbarMenu.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            this._toolbarMenu.dispose();
            this._toolbarMenu = null;
            this._actions.clear();
        }
    }

    class RecordAction
    extends Action {
        private File _file;

        public File getFile() {
            return this._file;
        }

        public RecordAction(File file) {
            super(file.getName(), 2);
            this._file = file;
            String id = file.getPath();
            this.setId(id);
            this.setChecked(false);
        }

        public void run() {
            boolean result = ImportRecordAction.this._recorderView.loadRecord(this._file);
            if (result) {
                Iterator it = ImportRecordAction.this._actions.iterator();
                while (it.hasNext()) {
                    ((Action)it.next()).setChecked(false);
                }
                ImportRecordAction.this._selected = this.getFile();
                this.setChecked(true);
            }
        }
    }
}

