/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.scenario;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Scenario_KindVSLevelConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Scenario sc;
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Scenario && (sc = (Scenario)eObj).eContainer() != null && !this.checkKindConsistency(sc)) {
            return ctx.createFailureStatus(new Object[]{sc.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private boolean checkKindConsistency(Scenario sc_p) {
        boolean result = true;
        EObject container = sc_p.eContainer();
        boolean layerfound = false;
        while (container != null) {
            layerfound = CsPackage.Literals.BLOCK_ARCHITECTURE.isSuperTypeOf(container.eClass());
            if (layerfound) break;
            container = container.eContainer();
        }
        if (layerfound) {
            ScenarioKind kind = sc_p.getKind();
            if (kind == ScenarioKind.UNSET) {
                return false;
            }
            if (container.eClass() == OaPackage.Literals.OPERATIONAL_ANALYSIS) {
                result = kind == ScenarioKind.INTERACTION;
            } else if (container.eClass() == CtxPackage.Literals.SYSTEM_ANALYSIS || container.eClass() == LaPackage.Literals.LOGICAL_ARCHITECTURE || container.eClass() == PaPackage.Literals.PHYSICAL_ARCHITECTURE) {
                result = kind == ScenarioKind.DATA_FLOW || kind == ScenarioKind.INTERFACE || kind == ScenarioKind.FUNCTIONAL;
            } else if (container.eClass() == EpbsPackage.Literals.EPBS_ARCHITECTURE) {
                result = kind == ScenarioKind.INTERFACE;
            }
        }
        return result;
    }
}

