/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.KeyValue;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentPortInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceProvider;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceRequirer;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ProviderRequirerRole;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.TracingStrategy;

class ProviderRequirerTracing
implements TracingStrategy {
    public static final String KEY_ROLE = "role";

    ProviderRequirerTracing() {
    }

    @Override
    public Collection<Interface> getTracingInterfaces(InterfaceInfo info) {
        if (info.getProvider() == null) {
            return this.getTracingInterfaces((TraceableElement)info.getRequirer().getEObject(), ProviderRequirerRole.REQUIRER, true);
        }
        if (info.getRequirer() == null) {
            return this.getTracingInterfaces((TraceableElement)info.getProvider().getEObject(), ProviderRequirerRole.PROVIDER, true);
        }
        Collection<Interface> result = this.getTracingInterfaces((TraceableElement)info.getProvider().getEObject(), ProviderRequirerRole.PROVIDER, false);
        Collection<Interface> required = this.getTracingInterfaces((TraceableElement)info.getRequirer().getEObject(), ProviderRequirerRole.REQUIRER, false);
        result.retainAll(required);
        return result;
    }

    @Override
    public void traceInterface(Interface iface, InterfaceInfo info) {
        if (info.getProvider() != null) {
            this.traceInterface(iface, ProviderRequirerRole.PROVIDER, (TraceableElement)info.getProvider().getEObject());
        }
        if (info.getRequirer() != null) {
            this.traceInterface(iface, ProviderRequirerRole.REQUIRER, (TraceableElement)info.getRequirer().getEObject());
        }
    }

    void traceInterface(Interface iface, ProviderRequirerRole role, TraceableElement target) {
        for (AbstractTrace t : iface.getOutgoingTraces()) {
            if (!(t instanceof TransfoLink) || t.getTargetElement() != target) continue;
            for (KeyValue kv : ((TransfoLink)t).getKeyValuePairs()) {
                if (!KEY_ROLE.equals(kv.getKey()) || !role.name().equals(kv.getValue())) continue;
                return;
            }
        }
        TransfoLink trace = CapellacommonFactory.eINSTANCE.createTransfoLink();
        KeyValue roleKv = CapellacoreFactory.eINSTANCE.createKeyValue();
        roleKv.setKey(KEY_ROLE);
        roleKv.setValue(role.name());
        trace.getKeyValuePairs().add((Object)roleKv);
        trace.setSourceElement((TraceableElement)iface);
        trace.setTargetElement(target);
        iface.getOwnedTraces().add((Object)trace);
    }

    private Collection<Interface> getTracingInterfaces(TraceableElement target, ProviderRequirerRole role, boolean singleRole) {
        LinkedHashSet<Interface> result = new LinkedHashSet<Interface>();
        for (AbstractTrace t : target.getIncomingTraces()) {
            if (!(t instanceof TransfoLink) || !(t.getSourceElement() instanceof Interface)) continue;
            Interface iface = null;
            for (KeyValue kv : ((TransfoLink)t).getKeyValuePairs()) {
                if (!KEY_ROLE.equals(kv.getKey())) continue;
                if (role.name().equals(kv.getValue())) {
                    iface = (Interface)t.getSourceElement();
                    continue;
                }
                if (!singleRole) continue;
                iface = null;
                break;
            }
            if (iface == null) continue;
            result.add(iface);
        }
        return result;
    }

    public InterfaceInfo getTracedInterfaceInfos(Interface generated) {
        InterfaceInfo result = null;
        InterfaceProvider provider = null;
        InterfaceRequirer requirer = null;
        for (AbstractTrace t : generated.getOutgoingTraces()) {
            if (!(t instanceof TransfoLink)) continue;
            if (provider != null) {
                provider = this.getProvider((TransfoLink)t);
            }
            if (requirer == null) continue;
            requirer = this.getRequirer((TransfoLink)t);
        }
        if (provider != null || requirer != null && provider != requirer) {
            result = new InterfaceInfo(provider, requirer, this);
        }
        return result;
    }

    private InterfaceRequirer getRequirer(TransfoLink t) {
        return (InterfaceRequirer)this.getTarget(t, ProviderRequirerRole.REQUIRER);
    }

    private InterfaceProvider getProvider(TransfoLink t) {
        return (InterfaceProvider)this.getTarget(t, ProviderRequirerRole.PROVIDER);
    }

    private Object getTarget(TransfoLink t, ProviderRequirerRole role) {
        for (KeyValue kv : t.getKeyValuePairs()) {
            if (!KEY_ROLE.equals(kv.getKey()) || role != ProviderRequirerRole.valueOf(kv.getValue())) continue;
            TraceableElement provider = t.getTarget();
            if (provider instanceof ComponentPort) {
                return new ComponentPortInterfaceAdapter((ComponentPort)provider);
            }
            if (!(provider instanceof Component)) continue;
            return new ComponentInterfaceAdapter((Component)provider);
        }
        return null;
    }
}

