/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.rules;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.core.Rule_CapellaElement;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class Rule_InterfacePkg
extends Rule_CapellaElement {
    public Rule_InterfacePkg() {
        super(CsPackage.Literals.INTERFACE_PKG, CsPackage.Literals.INTERFACE_PKG);
    }

    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
        if (!(element_p.eContainer() instanceof Component) && !(element_p.eContainer() instanceof BlockArchitecture)) {
            super.retrieveContainer(element_p, result_p, context_p);
        }
    }

    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        InterfacePkg result;
        BlockArchitecture architecture;
        if (element_p.eContainer() instanceof BlockArchitecture && (architecture = (BlockArchitecture)context_p.get("transfoTargetContainer")) != null && !(architecture instanceof PhysicalArchitecture) && (result = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)architecture)) != null) {
            LogHelper.getInstance().info(NLS.bind((String)ProjectionMessages.ElementTransitionedToExistingElement, (Object)EObjectLabelProviderHelper.getText((EObject)element_p), (Object)EObjectLabelProviderHelper.getText((EObject)result)), (Object)new Object[]{element_p, result}, ProjectionMessages.Activity_Transformation);
            return result;
        }
        return super.transformDirectElement(element_p, context_p);
    }

    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        InterfacePkg sourceElement = (InterfacePkg)source_p;
        if (this.isRelatedToSource((EObject)sourceElement, context_p)) {
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedInterfaces());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedInterfacePkgs());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedExchangeItems());
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        if (container_p instanceof Block) {
            return CsPackage.Literals.BLOCK__OWNED_INTERFACE_PKG;
        }
        if (container_p instanceof InterfacePkg) {
            return CsPackage.Literals.INTERFACE_PKG__OWNED_INTERFACE_PKGS;
        }
        if (container_p instanceof BlockArchitecture) {
            return CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_INTERFACE_PKG;
        }
        return super.getTargetContainementFeature(element_p, result_p, container_p, context_p);
    }

    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject sourceContainer;
        EObject bestContainer = super.getBestContainer(element_p, result_p, context_p);
        if (bestContainer != null && (sourceContainer = element_p.eContainer()) instanceof Component) {
            InterfacePkg dataPkg;
            EObject targetComponent = Query.retrieveFirstTransformedElement((EObject)sourceContainer, (ITransfo)context_p.getTransfo(), (EClass)CsPackage.Literals.COMPONENT);
            if (targetComponent == null) {
                targetComponent = Query.retrieveFirstTransformedElement((EObject)sourceContainer, (ITransfo)context_p.getTransfo());
                targetComponent = EcoreUtil2.getFirstContainer((EObject)targetComponent, (EClass)CsPackage.Literals.COMPONENT);
            }
            if (targetComponent != null && (dataPkg = ((Component)targetComponent).getOwnedInterfacePkg()) != null && dataPkg != result_p) {
                return dataPkg;
            }
            return targetComponent;
        }
        return bestContainer;
    }

    protected void attachContainement(EObject element_p, EObject result_p, IContext context_p) {
        super.attachContainement(element_p, result_p, context_p);
        if (result_p instanceof Structure) {
            Structure named = (Structure)result_p;
            if (!TraceabilityHandlerHelper.getInstance((IContext)context_p).retrieveTracedElements(element_p.eContainer(), context_p).contains(result_p.eContainer())) {
                named.setName(StructureExt.getNewStructureName((Structure)named, (EObject)element_p.eContainer()));
            }
        }
    }

    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        BlockArchitecture architecture = (BlockArchitecture)context_p.get("transfoTargetContainer");
        if (architecture != null) {
            if (element_p.eContainer() instanceof BlockArchitecture && !(architecture instanceof PhysicalArchitecture)) {
                return architecture;
            }
            return BlockArchitectureExt.getInterfacePkg((BlockArchitecture)architecture);
        }
        return super.getDefaultContainer(element_p, result_p, context_p);
    }
}

