/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.af.integration.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.ad.viewpoint.ui.provider.AFSelectionProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointView;

public class CapellaSelectionProvider
implements AFSelectionProvider {
    private final List<Object> selectedObjects = new ArrayList<Object>();
    private final List<ISelectionListener> listeners = new ArrayList<ISelectionListener>();
    private final ISelectionListener listener;

    public CapellaSelectionProvider() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof ViewpointView) {
                    return;
                }
                CapellaSelectionProvider.this.selectedObjects.clear();
                if (selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        CapellaSelectionProvider.this.selectedObjects.add(obj);
                        ++n2;
                    }
                }
                for (ISelectionListener listener : CapellaSelectionProvider.this.listeners) {
                    listener.selectionChanged(part, selection);
                }
            }
        };
        selectionService.addSelectionListener(this.listener);
    }

    public List<Object> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : this.selectedObjects) {
            if (obj instanceof AbstractEditPart && (obj = ((AbstractEditPart)obj).getModel()) instanceof Node && (obj = ((Node)obj).getElement()) instanceof DRepresentationElement) {
                obj = ((DRepresentationElement)obj).getTarget();
            }
            result.add(obj);
        }
        return result;
    }

    public void addListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener(this.listener);
    }
}

