/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.progress.view;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoProgressShell
extends Observable
implements Observer {
    Shell sShell = null;
    ProgressBar _progressBar = null;
    private CLabel _message = null;
    Text _textArea = null;
    private Button _details = null;
    private Button _cancelOrClose = null;
    private Button _pauseOrResume = null;
    Composite _top;
    private Rectangle _bounds;
    private Rectangle _topBounds;
    protected boolean _disposeAtEnd = false;
    protected boolean _isStoppable = false;
    protected boolean _isRunning = true;
    final Display _display;
    StringBuffer _detailedMessageCache = null;
    Observer _model = null;

    public InfoProgressShell() {
        this._display = new Display();
        this.init();
    }

    public InfoProgressShell(Display display, Observer observer) {
        this._display = display;
        this._model = observer;
        this.addObserver(this._model);
        if (this._model instanceof Observable) {
            Observable observable = (Observable)((Object)this._model);
            observable.addObserver(this);
        }
        this.init();
    }

    private void init() {
        this.createSShell();
        Rectangle rect = this.sShell.getBounds();
        this._topBounds = new Rectangle(rect.x, rect.y, 600, 140);
        this._bounds = new Rectangle(rect.x, rect.y, this._topBounds.width, this._topBounds.height + 300);
        this.sShell.setBounds(this._topBounds);
        this.setDetailMode(false);
        this.setStoppable(false);
        this._detailedMessageCache = new StringBuffer();
    }

    public void setTitle(String titleString) {
        this.sShell.setText(titleString);
    }

    public int getMaximum() {
        return this._progressBar.getMaximum();
    }

    public void setMaximum(int valueI) {
        this._progressBar.setMaximum(valueI);
    }

    public void setSelection(int valueI) {
        this._progressBar.setSelection(valueI);
        float pourcent = (float)valueI / (float)this.getMaximum() * 100.0f;
        this.sShell.setText(String.valueOf((int)pourcent) + "%");
    }

    public void setStoppable(boolean isStoppable) {
        this._isStoppable = isStoppable;
        this._cancelOrClose.setEnabled(this._isStoppable);
    }

    public void setDisposeAtEnd(boolean disposeAtEnd) {
        this._disposeAtEnd = disposeAtEnd;
    }

    public void setVisible(boolean visibleB) {
        this.sShell.setVisible(visibleB);
    }

    public void setDetailMode(boolean showDetailB) {
        this._textArea.setVisible(showDetailB);
        Rectangle rect = this.sShell.getBounds();
        this._topBounds = new Rectangle(rect.x, rect.y, this._topBounds.width, this._topBounds.height);
        this._bounds = new Rectangle(rect.x, rect.y, this._bounds.width, this._bounds.height);
        if (!showDetailB) {
            this._details.setText(">>");
            this.sShell.setBounds(this._topBounds);
        } else {
            this._details.setText("<<");
            this.sShell.setBounds(this._bounds);
        }
    }

    public boolean isDetailMode() {
        return this._textArea.isVisible();
    }

    public boolean isDisposed() {
        return this.sShell.isDisposed();
    }

    public void setMessage(String messageString) {
        this._message.setText(messageString);
    }

    public void appendDetailedMessage(String messageString) {
        this._detailedMessageCache.append(messageString);
        this._detailedMessageCache.append(System.getProperty("line.separator"));
        try {
            this._display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (InfoProgressShell.this.isDisposed()) {
                        return;
                    }
                    StringBuffer stringBuffer = InfoProgressShell.this._detailedMessageCache;
                    synchronized (stringBuffer) {
                        InfoProgressShell.this._textArea.append(InfoProgressShell.this._detailedMessageCache.toString());
                        InfoProgressShell.this._detailedMessageCache.setLength(0);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearDetailedMessage() {
        try {
            this._display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (InfoProgressShell.this.isDisposed()) {
                        return;
                    }
                    InfoProgressShell.this._textArea.setText("");
                    InfoProgressShell.this._detailedMessageCache.setLength(0);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void open() {
        Monitor monitor = this._display.getMonitors()[0];
        Rectangle screen = monitor.getBounds();
        Rectangle rect = this.sShell.getBounds();
        this.sShell.setBounds((screen.width - rect.width) / 2, (screen.height - rect.height) / 2, rect.width, rect.height);
        this.sShell.open();
        while (!this.sShell.isDisposed()) {
            if (this._display.readAndDispatch()) continue;
            this._display.sleep();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this._display.isDisposed()) {
            return;
        }
        try {
            if (arg instanceof Integer) {
                final Integer progress = (Integer)arg;
                this._display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InfoProgressShell.this.isDisposed()) {
                            return;
                        }
                        InfoProgressShell.this.setSelection(progress);
                    }
                });
            } else if (arg instanceof HashMap) {
                HashMap progress = (HashMap)arg;
                this.update(progress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(final HashMap<String, Object> properties) {
        String detailedMessage = (String)properties.get("DetailedMessage");
        if (detailedMessage != null) {
            this.appendDetailedMessage(detailedMessage);
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer min = (Integer)properties.get("Min");
                if (min != null) {
                    InfoProgressShell.this._progressBar.setMinimum(min.intValue());
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer max = (Integer)properties.get("Max");
                if (max != null) {
                    InfoProgressShell.this.setMaximum(max);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Integer progress = (Integer)properties.get("Progress");
                if (progress != null) {
                    InfoProgressShell.this.setSelection(progress);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                Boolean finished = (Boolean)properties.get("Finished");
                if (finished != null) {
                    InfoProgressShell.this.setFinished(finished);
                }
                if (InfoProgressShell.this.isDisposed()) {
                    return;
                }
                String message = (String)properties.get("Message");
                if (message != null) {
                    InfoProgressShell.this.setMessage(message);
                }
            }
        });
    }

    protected void setFinished(boolean finished) {
        if (finished) {
            this.setSelection(this.getMaximum());
            if (this._disposeAtEnd) {
                this.close();
            } else {
                this._cancelOrClose.setText("Close");
                this._cancelOrClose.setEnabled(true);
            }
        }
    }

    private void createTop() {
        GridData gridData15 = new GridData();
        gridData15.grabExcessHorizontalSpace = false;
        gridData15.verticalAlignment = 1;
        gridData15.horizontalAlignment = 4;
        GridData gridData14 = new GridData();
        gridData14.grabExcessHorizontalSpace = true;
        gridData14.verticalAlignment = 2;
        gridData14.horizontalSpan = 3;
        gridData14.horizontalAlignment = 4;
        GridData gridData1 = new GridData();
        gridData1.widthHint = 100;
        gridData1.verticalAlignment = 2;
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.horizontalAlignment = 3;
        GridData gridData = new GridData();
        gridData.heightHint = -1;
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 100;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 3;
        gridData4.grabExcessHorizontalSpace = false;
        gridData4.widthHint = 100;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.verticalAlignment = 2;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalSpan = 3;
        gridData3.horizontalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        this._top = new Composite((Composite)this.sShell, 0);
        this._top.setLayout((Layout)gridLayout1);
        this._top.setLayoutData((Object)gridData15);
        this._message = new CLabel(this._top, 0);
        this._message.setText("");
        this._message.setLayoutData((Object)gridData14);
        this._progressBar = new ProgressBar(this._top, 65536);
        this._progressBar.setLayoutData((Object)gridData3);
        this._details = new Button(this._top, 0);
        this._details.setText(">>");
        this._details.setLayoutData((Object)gridData);
        this._pauseOrResume = new Button(this._top, 0);
        this._pauseOrResume.setText("Pause");
        this._pauseOrResume.setLayoutData((Object)gridData4);
        this._cancelOrClose = new Button(this._top, 0);
        this._cancelOrClose.setText("Cancel");
        this._cancelOrClose.setLayoutData((Object)gridData1);
        this._pauseOrResume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.switchActive();
            }
        });
        this._cancelOrClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.close();
            }
        });
        this._details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoProgressShell.this.switchDetail();
            }
        });
    }

    protected void close() {
        this.deleteObserver(this._model);
        if (this._model instanceof Observable) {
            Observable observable = (Observable)((Object)this._model);
            observable.deleteObserver(this);
        }
        this.sShell.dispose();
    }

    protected void switchActive() {
        this._isRunning = !this._isRunning;
        this.setChanged();
        this.notifyObservers();
        if (this._isRunning) {
            this._pauseOrResume.setText("Pause");
        } else {
            this._pauseOrResume.setText("Resume");
        }
    }

    protected void switchDetail() {
        this.setDetailMode(!this.isDetailMode());
    }

    private void createSShell() {
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        this.sShell = new Shell(82000);
        this.sShell.setText("");
        this.sShell.setLayout((Layout)new GridLayout());
        this.createTop();
        this._textArea = new Text((Composite)this.sShell, 2570);
        this._textArea.setEditable(false);
        this._textArea.setBackground(Display.getCurrent().getSystemColor(1));
        this._textArea.setLayoutData((Object)gridData2);
        this._textArea.setEnabled(true);
    }
}

