/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.menu.dynamic;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.polarsys.capella.common.menu.dynamic.AbstractActionProvider;
import org.polarsys.capella.common.menu.dynamic.contributions.ActionContributionProvider;
import org.polarsys.capella.core.menu.dynamic.DynamicActionContributionItem;
import org.polarsys.capella.core.menu.dynamic.DynamicCreationAction;
import org.polarsys.capella.core.menu.dynamic.Messages;

public class DynamicActionProvider
extends AbstractActionProvider {
    private DynamicCreationAction _dynamicAction;

    public DynamicActionProvider() {
        ActionContributionProvider.getInstance();
    }

    protected void initActions(Shell shell_p, IWorkbenchPage page_p, ISelectionProvider selectionProvider_p) {
        this._dynamicAction = new DynamicCreationAction(shell_p, selectionProvider_p);
    }

    protected IContributionItem createContributionItem() {
        MenuManager subMenuManager = new MenuManager(Messages.DynamicActionProvider_AddCapellaElement_Title, "Dynamic.Menu.ID");
        this.fillContextMenu((IMenuManager)subMenuManager, this._dynamicAction, null);
        return subMenuManager;
    }

    public void fillContextMenu(IMenuManager menu_p) {
        menu_p.insertAfter("group.new", this.createContributionItem());
    }

    public void fillActionBars(IActionBars actionBars_p) {
    }

    protected void fillContextMenu(IMenuManager menu_p, DynamicCreationAction action_p, String groupId_p) {
        if (action_p.isSelectionCompatible()) {
            for (IContributionItem item : action_p.getStructuralDynamicActions()) {
                this.addContributionItem(menu_p, groupId_p, item);
            }
            menu_p.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action_p.getNonStructuralDynamicActions()) {
                this.addContributionItem(menu_p, groupId_p, containedAction);
            }
            menu_p.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action_p.getPropertyValueDynamicActions()) {
                this.addContributionItem(menu_p, groupId_p, containedAction);
            }
            menu_p.add((IContributionItem)new Separator());
            for (IContributionItem containedAction : action_p.getExtensionDynamicActions()) {
                this.addContributionItem(menu_p, groupId_p, containedAction);
            }
        }
    }

    protected void addContributionItem(IMenuManager menu_p, String groupId_p, IContributionItem item_p) {
        if (groupId_p != null) {
            menu_p.appendToGroup(groupId_p, item_p);
        } else {
            menu_p.add(item_p);
        }
    }

    protected void addAction(IMenuManager menu_p, String groupId_p, IAction action_p) {
        this.addContributionItem(menu_p, groupId_p, (IContributionItem)new DynamicActionContributionItem(action_p));
    }
}

