/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class RefinementServices {
    public static List<Part> getReferencerParts(Component component) {
        ArrayList<Part> partSet = new ArrayList<Part>();
        for (EObject referencer : EObjectExt.getReferencers((EObject)component, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            if (!(referencer instanceof Part)) continue;
            partSet.add((Part)referencer);
        }
        return partSet;
    }

    public static AbstractEventOperation getDelegatedOperation(CapellaElement srcElt, CapellaElement tgtElt, AbstractEventOperation currentOp) {
        AbstractEventOperation finalOp = null;
        CapellaLayerCheckingExt.LAYERSNAME srcLayer = CapellaLayerCheckingExt.getLayersName((CapellaElement)srcElt);
        CapellaLayerCheckingExt.LAYERSNAME tgtLayer = CapellaLayerCheckingExt.getLayersName((CapellaElement)tgtElt);
        if (srcLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.CTX) && tgtLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.LA)) {
            for (AbstractEventOperation traceElt : RefinementServices.getDelegatedAndRefinedOperations(currentOp, true)) {
                if (!CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)traceElt)) continue;
                finalOp = traceElt;
            }
        } else if (srcLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.LA) && tgtLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.LA)) {
            for (AbstractEventOperation traceElt : RefinementServices.getDelegatedAndRefinedOperations(currentOp, true)) {
                if (!CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)traceElt)) continue;
                finalOp = traceElt;
            }
        } else if (srcLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.LA) && tgtLayer.equals((Object)CapellaLayerCheckingExt.LAYERSNAME.PA)) {
            for (AbstractEventOperation traceElt : RefinementServices.getDelegatedAndRefinedOperations(currentOp, true)) {
                if (!CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)traceElt)) continue;
                finalOp = traceElt;
            }
        }
        if (finalOp != null) {
            return finalOp;
        }
        return currentOp;
    }

    public static List<AbstractEventOperation> getDelegatedAndRefinedOperations(AbstractEventOperation currentOp, boolean reverse) {
        ArrayList<AbstractEventOperation> opsDelegated = new ArrayList<AbstractEventOperation>();
        opsDelegated.addAll(RefinementServices.getDelegatedOperations(currentOp, reverse));
        opsDelegated.addAll(RefinementServices.getRefinedOperations(currentOp, reverse));
        return opsDelegated;
    }

    protected static List<AbstractEventOperation> getDelegatedOperations(AbstractEventOperation currentOp, boolean reverse) {
        return RefinementServices.getRelatedElement((TraceableElement)currentOp, CapellacommonPackage.Literals.TRANSFO_LINK, reverse);
    }

    protected static List<AbstractEventOperation> getRefinedOperations(AbstractEventOperation currentOp, boolean reverse) {
        return RefinementServices.getRelatedElement((TraceableElement)currentOp, InteractionPackage.Literals.REFINEMENT_LINK, reverse);
    }

    protected static List<AbstractEventOperation> getRelatedElement(TraceableElement src, EClass linkMC, boolean reverse) {
        ArrayList<AbstractEventOperation> opsDelegated = new ArrayList<AbstractEventOperation>();
        for (TraceableElement traceableElement : RefinementServices.getRelatedElement(src, InformationPackage.Literals.ABSTRACT_EVENT_OPERATION, linkMC, reverse)) {
            opsDelegated.add((AbstractEventOperation)traceableElement);
        }
        return opsDelegated;
    }

    protected static List<? extends TraceableElement> getRelatedElement(TraceableElement src, EClass tgtMC, EClass linkMC, boolean reverse) {
        ArrayList<TraceableElement> traceableElts = new ArrayList<TraceableElement>();
        for (AbstractTrace abstractTrace : reverse ? src.getIncomingTraces() : src.getOutgoingTraces()) {
            TraceableElement traceableElt;
            if (abstractTrace.eClass() != linkMC) continue;
            TraceableElement traceableElement = traceableElt = reverse ? abstractTrace.getSourceElement() : abstractTrace.getTargetElement();
            if (traceableElt == null || !tgtMC.equals(traceableElt.eClass()) && !tgtMC.isSuperTypeOf(traceableElt.eClass()) || traceableElts.contains(traceableElt)) continue;
            traceableElts.add(traceableElt);
        }
        return traceableElts;
    }
}

