/*******************************************************************************
 * Copyright (c) 2006, 2014 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.flexibility.wizards.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyControl;

/**
 * Temporary class to allow configuration/preference management
 *
 */
public abstract class CapellaPropertyPreferencePage extends AbstractDefaultPreferencePage implements PropertyChangeListener, IWorkbenchPreferencePage {

  /**
   * @param propertyPageId_p
   */
  public CapellaPropertyPreferencePage(String propertyPageId_p) {
    super(propertyPageId_p);
  }

  /**
   * @return the context
   */
  public abstract IPropertyContext getContext();

  /**
   * @return the renderers
   */
  public abstract IRendererContext getRendererContext();

  /**
   * {@inheritDoc}
   */
  @Override
  public void init(IWorkbench workbench_p) {
    IPropertyContext context = getContext();
    if (context != null) {
      context.registerListener(this);
    }
  }

  /**
   * @return
   */
  protected ILabelProvider getLabelProvider() {
    return getRendererContext().getLabelProvider();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performApply() {
    super.performApply();
    IPropertyContext context = getContext();
    if (context != null) {
      context.writeAll();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean performOk() {
    IPropertyContext context = getContext();
    if (context != null) {
      context.writeAll();
    }
    return super.performOk();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performDefaults() {
    super.performDefaults();
    IPropertyContext context = getContext();
    if (context != null) {
      context.setDefaults();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Control createContents(Composite parent_p) {
    ILabelProvider labelProvider = getLabelProvider();
    PropertyControl control = new PropertyControl(labelProvider, getContext(), getRendererContext()) {

      @Override
      protected boolean isFlat() {
        return true;
      }
    };
    Control composite = control.createControl(parent_p);
    setEnable((Composite) composite, UserProfileModeEnum.Expert);
	return composite;
  }

  protected void applyToStatusLine(IStatus status) {
    String message = status.getMessage();
    if ((message == null) || (message.length() == 0)) {
      setErrorMessage(null);
      setMessage(getDescription());

    } else {
      switch (status.getSeverity()) {
        case IStatus.OK:
          setErrorMessage(null);
          setMessage(getDescription());
        break;
        case IStatus.WARNING:
          setErrorMessage(null);
          setMessage(message, IMessageProvider.WARNING);
        break;
        case IStatus.INFO:
          setErrorMessage(null);
          setMessage(message, IMessageProvider.INFORMATION);
        break;
        default:
          setErrorMessage(null);
          setMessage(message, IMessageProvider.ERROR);
        break;
      }
    }
  }

  protected IStatus findMostSevere() {
    IPropertyContext context = getContext();
    if (context != null) {
      IProperties properties = context.getProperties();
      if (properties != null) {
        for (IProperty item : properties.getAllItems()) {
          IStatus status = item.validate(context.getCurrentValue(item), context);
          if (!status.isOK()) {
            return status;
          }
        }
      }
    }
    return Status.OK_STATUS;
  }

  /**
   * {@inheritDoc}
   */
  public void update(PropertyChangedEvent event_p) {
    applyToStatusLine(findMostSevere());
  }

}
