/*******************************************************************************
 * Copyright (c) 2006, 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.af.integration;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.core.af.integration.listener.CapellaExplorerUpdater;
import org.polarsys.capella.core.af.integration.listener.SemanticBrowserUpdater;
import org.polarsys.kitalpha.emde.extension.ModelExtensionHelper;
import org.polarsys.kitalpha.emde.extension.ModelExtensionOverallListener;

/**
 * Plugin activator
 */
@SuppressWarnings({"findbugs:ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD","squid:S2696"})
public class AFIntegrationPlugin extends AbstractUIPlugin {

	// The shared instance
	private static AFIntegrationPlugin plugin;
	private final ModelExtensionOverallListener[] listeners = { new CapellaExplorerUpdater(), new SemanticBrowserUpdater() };

	// The identifier of the Capella "virtual" viewpoint
	public static final String CAPELLA_VIEWPOINT_ID = "org.polarsys.capella.core.viewpoint";
	
	/**
	 * The constructor
	 */
	public AFIntegrationPlugin() {
	}

	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	    for (ModelExtensionOverallListener l : listeners)
	        ModelExtensionHelper.addOverallListener(l);
	}

	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
	    for (ModelExtensionOverallListener l : listeners)
	        ModelExtensionHelper.removeOverallListener(l);
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static AFIntegrationPlugin getDefault() {
		return plugin;
	}

	public static String getSymbolicName() {
		return plugin.getBundle().getSymbolicName();
	}
}
