/*******************************************************************************
 * Copyright (c) 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.transition.system.handlers.merge;

import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.transition.system.preferences.PreferenceConstants;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentFilter extends EObjectCategoryFilter {

  public ComponentFilter(IContext context) {
    super(context, CtxPackage.Literals.SYSTEM, PreferenceConstants.P_C_TEXT);
  }

  @Override
  public boolean keepElement(Object element) {
    return element instanceof Component && !(element instanceof AbstractActor)
        && !(element instanceof ComponentContext);
  }

}
