/*******************************************************************************
 * Copyright (c) 2006, 2015 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.capellacommon.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.util.CapellacommonAdapterFactory;
import org.polarsys.capella.core.data.capellamodeller.provider.CapellaModellerEditPlugin;
import org.polarsys.kitalpha.emde.extension.edit.ChildCreationExtenderManager;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CapellacommonItemProviderAdapterFactory extends CapellacommonAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(CapellaModellerEditPlugin.INSTANCE, CapellacommonPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CapellacommonItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.GenericTrace} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericTraceItemProvider genericTraceItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.GenericTrace}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGenericTraceAdapter() {
		if (genericTraceItemProvider == null) {
			genericTraceItemProvider = new GenericTraceItemProvider(this);
		}

		return genericTraceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.TransfoLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransfoLinkItemProvider transfoLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.TransfoLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransfoLinkAdapter() {
		if (transfoLinkItemProvider == null) {
			transfoLinkItemProvider = new TransfoLinkItemProvider(this);
		}

		return transfoLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.JustificationLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JustificationLinkItemProvider justificationLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.JustificationLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJustificationLinkAdapter() {
		if (justificationLinkItemProvider == null) {
			justificationLinkItemProvider = new JustificationLinkItemProvider(this);
		}

		return justificationLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.StateMachine} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateMachineItemProvider stateMachineItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.StateMachine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateMachineAdapter() {
		if (stateMachineItemProvider == null) {
			stateMachineItemProvider = new StateMachineItemProvider(this);
		}

		return stateMachineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.Region} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegionItemProvider regionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.Region}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegionAdapter() {
		if (regionItemProvider == null) {
			regionItemProvider = new RegionItemProvider(this);
		}

		return regionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.State} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateItemProvider stateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.State}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateAdapter() {
		if (stateItemProvider == null) {
			stateItemProvider = new StateItemProvider(this);
		}

		return stateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.Mode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeItemProvider modeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.Mode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeAdapter() {
		if (modeItemProvider == null) {
			modeItemProvider = new ModeItemProvider(this);
		}

		return modeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.FinalState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FinalStateItemProvider finalStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.FinalState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFinalStateAdapter() {
		if (finalStateItemProvider == null) {
			finalStateItemProvider = new FinalStateItemProvider(this);
		}

		return finalStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.StateTransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateTransitionItemProvider stateTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.StateTransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateTransitionAdapter() {
		if (stateTransitionItemProvider == null) {
			stateTransitionItemProvider = new StateTransitionItemProvider(this);
		}

		return stateTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.InitialPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InitialPseudoStateItemProvider initialPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.InitialPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInitialPseudoStateAdapter() {
		if (initialPseudoStateItemProvider == null) {
			initialPseudoStateItemProvider = new InitialPseudoStateItemProvider(this);
		}

		return initialPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.JoinPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinPseudoStateItemProvider joinPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.JoinPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJoinPseudoStateAdapter() {
		if (joinPseudoStateItemProvider == null) {
			joinPseudoStateItemProvider = new JoinPseudoStateItemProvider(this);
		}

		return joinPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.ForkPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForkPseudoStateItemProvider forkPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.ForkPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForkPseudoStateAdapter() {
		if (forkPseudoStateItemProvider == null) {
			forkPseudoStateItemProvider = new ForkPseudoStateItemProvider(this);
		}

		return forkPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.ChoicePseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChoicePseudoStateItemProvider choicePseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.ChoicePseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChoicePseudoStateAdapter() {
		if (choicePseudoStateItemProvider == null) {
			choicePseudoStateItemProvider = new ChoicePseudoStateItemProvider(this);
		}

		return choicePseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.TerminatePseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TerminatePseudoStateItemProvider terminatePseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.TerminatePseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTerminatePseudoStateAdapter() {
		if (terminatePseudoStateItemProvider == null) {
			terminatePseudoStateItemProvider = new TerminatePseudoStateItemProvider(this);
		}

		return terminatePseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.AbstractStateRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractStateRealizationItemProvider abstractStateRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.AbstractStateRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractStateRealizationAdapter() {
		if (abstractStateRealizationItemProvider == null) {
			abstractStateRealizationItemProvider = new AbstractStateRealizationItemProvider(this);
		}

		return abstractStateRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.StateTransitionRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateTransitionRealizationItemProvider stateTransitionRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.StateTransitionRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateTransitionRealizationAdapter() {
		if (stateTransitionRealizationItemProvider == null) {
			stateTransitionRealizationItemProvider = new StateTransitionRealizationItemProvider(this);
		}

		return stateTransitionRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.ShallowHistoryPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ShallowHistoryPseudoStateItemProvider shallowHistoryPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.ShallowHistoryPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createShallowHistoryPseudoStateAdapter() {
		if (shallowHistoryPseudoStateItemProvider == null) {
			shallowHistoryPseudoStateItemProvider = new ShallowHistoryPseudoStateItemProvider(this);
		}

		return shallowHistoryPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.DeepHistoryPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeepHistoryPseudoStateItemProvider deepHistoryPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.DeepHistoryPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeepHistoryPseudoStateAdapter() {
		if (deepHistoryPseudoStateItemProvider == null) {
			deepHistoryPseudoStateItemProvider = new DeepHistoryPseudoStateItemProvider(this);
		}

		return deepHistoryPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.EntryPointPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntryPointPseudoStateItemProvider entryPointPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.EntryPointPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEntryPointPseudoStateAdapter() {
		if (entryPointPseudoStateItemProvider == null) {
			entryPointPseudoStateItemProvider = new EntryPointPseudoStateItemProvider(this);
		}

		return entryPointPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.ExitPointPseudoState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExitPointPseudoStateItemProvider exitPointPseudoStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.ExitPointPseudoState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExitPointPseudoStateAdapter() {
		if (exitPointPseudoStateItemProvider == null) {
			exitPointPseudoStateItemProvider = new ExitPointPseudoStateItemProvider(this);
		}

		return exitPointPseudoStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.StateEventRealization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateEventRealizationItemProvider stateEventRealizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.StateEventRealization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateEventRealizationAdapter() {
		if (stateEventRealizationItemProvider == null) {
			stateEventRealizationItemProvider = new StateEventRealizationItemProvider(this);
		}

		return stateEventRealizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.ChangeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeEventItemProvider changeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.ChangeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeEventAdapter() {
		if (changeEventItemProvider == null) {
			changeEventItemProvider = new ChangeEventItemProvider(this);
		}

		return changeEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.capella.core.data.capellacommon.TimeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeEventItemProvider timeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.capella.core.data.capellacommon.TimeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeEventAdapter() {
		if (timeEventItemProvider == null) {
			timeEventItemProvider = new TimeEventItemProvider(this);
		}

		return timeEventItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (genericTraceItemProvider != null) genericTraceItemProvider.dispose();
		if (transfoLinkItemProvider != null) transfoLinkItemProvider.dispose();
		if (justificationLinkItemProvider != null) justificationLinkItemProvider.dispose();
		if (stateMachineItemProvider != null) stateMachineItemProvider.dispose();
		if (regionItemProvider != null) regionItemProvider.dispose();
		if (stateItemProvider != null) stateItemProvider.dispose();
		if (modeItemProvider != null) modeItemProvider.dispose();
		if (finalStateItemProvider != null) finalStateItemProvider.dispose();
		if (stateTransitionItemProvider != null) stateTransitionItemProvider.dispose();
		if (initialPseudoStateItemProvider != null) initialPseudoStateItemProvider.dispose();
		if (joinPseudoStateItemProvider != null) joinPseudoStateItemProvider.dispose();
		if (forkPseudoStateItemProvider != null) forkPseudoStateItemProvider.dispose();
		if (choicePseudoStateItemProvider != null) choicePseudoStateItemProvider.dispose();
		if (terminatePseudoStateItemProvider != null) terminatePseudoStateItemProvider.dispose();
		if (abstractStateRealizationItemProvider != null) abstractStateRealizationItemProvider.dispose();
		if (stateTransitionRealizationItemProvider != null) stateTransitionRealizationItemProvider.dispose();
		if (shallowHistoryPseudoStateItemProvider != null) shallowHistoryPseudoStateItemProvider.dispose();
		if (deepHistoryPseudoStateItemProvider != null) deepHistoryPseudoStateItemProvider.dispose();
		if (entryPointPseudoStateItemProvider != null) entryPointPseudoStateItemProvider.dispose();
		if (exitPointPseudoStateItemProvider != null) exitPointPseudoStateItemProvider.dispose();
		if (stateEventRealizationItemProvider != null) stateEventRealizationItemProvider.dispose();
		if (changeEventItemProvider != null) changeEventItemProvider.dispose();
		if (timeEventItemProvider != null) timeEventItemProvider.dispose();
	}

}
