/*******************************************************************************
 * Copyright (c) 2006, 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

package org.polarsys.capella.core.semantic.queries.basic.queries;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;

import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.common.helpers.query.IQuery;

/**
 * 
 */
public class SystemComponent_internalOutgoingInformationflows implements IQuery {
 
	/**
	 * 
	 */
	public SystemComponent_internalOutgoingInformationflows() {
	  // do nothing
	}

	/**
	 * Gathering recursively all sub components:
	 * current.ownedPartitions.type.componentPorts.outgoingFlows
	 * 
	 * @see org.polarsys.capella.common.helpers.query.IQuery#compute(java.lang.Object)
	 */
	public List<Object> compute(Object object) {
	  List<Object> result = new ArrayList<Object>();
    if (object instanceof SystemComponent) {
      SystemComponent lc = (SystemComponent) object;
      EList<Partition> partitions = lc.getOwnedPartitions();
      for (Partition partition : partitions) {
        Type subcomp = partition.getType();
        if (null != subcomp) {
          if (subcomp instanceof Component) {
            SystemComponent_outgoingInformationflows outgoingInfoFlows = new SystemComponent_outgoingInformationflows();
            List<Object> computes = outgoingInfoFlows.compute(subcomp);
            if (!computes.isEmpty()) {
              result.addAll(computes);
            }
          }
        }
      }
    }
    return result;
	}

}
