/*******************************************************************************
 * Copyright (c) 2006, 2015 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.cs;

import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Abstract Actor</b></em>'.
 * <!-- end-user-doc -->
 *
 *
 * @see org.polarsys.capella.core.data.cs.CsPackage#getAbstractActor()
 * @model abstract="true"
 *        annotation="http://www.polarsys.org/capella/2007/BusinessInformation Label='AbstractActor'"
 *        annotation="http://www.polarsys.org/capella/2007/UML2Mapping metaclass='Component'"
 *        annotation="http://www.polarsys.org/kitalpha/ecore/documentation description='An Actor models a type of role played by an entity that interacts with the subject (e.g., by exchanging signals and data),\r\nbut which is external to the subject (i.e., in the sense that an instance of an actor is not a part of the instance of its corresponding subject). \r\n\r\nActors may represent roles played by human users, external hardware, or other subjects.\r\nNote that an actor does not necessarily represent a specific physical entity but merely a particular facet (i.e., \'role\') of some entity\r\nthat is relevant to the specification of its associated use cases. Thus, a single physical instance may play the role of\r\nseveral different actors and, conversely, a given actor may be played by multiple different instances.\r\n[source: UML superstructure v2.2]' usage\040guideline='none' used\040in\040levels='n/a (abstract)' usage\040examples='n/a' constraints='none' comment/notes='none' reference\040documentation='none'"
 *        annotation="http://www.polarsys.org/capella/MNoE/CapellaLike/Mapping UML/SysML\040semantic\040equivalences='' base\040metaclass\040in\040UML/SysML\040profile\040='' explanation='SysML::Blocks::Block' constraints='none'"
 * @generated
 */
public interface AbstractActor extends Component, CapabilityRealizationInvolvedElement {



} // AbstractActor
