/*******************************************************************************
 * Copyright (c) 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.transition.system.topdown.handlers.merge;

import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.transition.common.constants.ITransitionConstants;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.constants.ITopDownConstants;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

/**
 * This category enables or disables the differences for appliedPropertyValues according to the preference in the Window
 * / Preferences / Transitions
 */
public class AppliedPropertyValuesCategoryFilter extends CategoryFilter {

  public AppliedPropertyValuesCategoryFilter(IContext context) {
    super(context, Messages.AppliedPropertyValuesCategoryFilter, Messages.AppliedPropertyValuesCategoryFilter_Description);
    setCategorySet(ITransitionConstants.CATEGORY_BUSINESS);
    setInFocusMode(false); 
    setVisible(true);

    boolean active = (OptionsHandlerHelper.getInstance(context).getBooleanValue(context,
        ITopDownConstants.OPTIONS_SCOPE, ITopDownConstants.OPTIONS__PROPERTY_VALUE__APPLIED_PROPERTY_VALUES,
        ITopDownConstants.OPTIONS__PROPERTY_VALUE__APPLIED_PROPERTY_VALUES__DEFAULT.booleanValue()));
    setActive(!active);
  }

  @Override
  public boolean covers(EStructuralFeature feature) {
    if ((CapellacorePackage.Literals.CAPELLA_ELEMENT__APPLIED_PROPERTY_VALUES.equals(feature)
        || CapellacorePackage.Literals.CAPELLA_ELEMENT__APPLIED_PROPERTY_VALUE_GROUPS.equals(feature))) {
      return true;
    }
    return super.covers(feature);
  }

  @Override
  public boolean covers(IDifference difference) {
    if (difference instanceof IReferenceValuePresence) {
      EReference feature = ((IReferenceValuePresence) difference).getFeature();
      return covers(feature);
    }
    return false;

  }

}
