/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.utils.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;

public class BasicDirectedGraph<T>
implements IDirectedGraph<T> {
    private Map<T, List<T>> edges = new HashMap<T, List<T>>();

    @Override
    public Iterator<T> getSucessors(T source) {
        Iterator<T> successors;
        List<T> successorList = this.edges.get(source);
        if (successorList == null) {
            successorList = Collections.emptyList();
            successors = successorList.iterator();
        } else {
            successors = successorList.iterator();
        }
        return successors;
    }

    public void addEdge(T source, T successor) {
        List<T> sucessors = this.edges.get(source);
        if (sucessors == null) {
            sucessors = new ArrayList<T>();
            this.edges.put(source, sucessors);
        }
        sucessors.add(successor);
        this.edges.put(successor, this.edges.get(successor));
    }

    public void addNode(T node) {
        this.edges.put(node, this.edges.get(node));
    }

    @Override
    public Iterator<T> getNodes() {
        return this.edges.keySet().iterator();
    }
}

