/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class DecompositionTreeNodeContentProvider
extends TreeNodeContentProvider {
    private boolean synthesisCheckPage;
    protected DecompositionModel model;

    public DecompositionTreeNodeContentProvider(DecompositionModel model_p, boolean synthesisCheckPage_p) {
        this.setSynthesisCheckPage(synthesisCheckPage_p);
        this.model = model_p;
    }

    public DecompositionTreeNodeContentProvider(DecompositionModel model_p) {
        this(model_p, false);
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        super.inputChanged(viewer_p, oldInput_p, newInput_p);
    }

    private List<DecompositionItem> getFilteredItems(DecompositionComponent component) {
        ArrayList<DecompositionItem> res = new ArrayList<DecompositionItem>();
        for (DecompositionItem item : component.getItems()) {
            if (this.model.isTechnicalInterface(item) && this.model.doesHideTechnicalInterfaces()) continue;
            res.add(item);
        }
        return res;
    }

    public Object[] getElements(Object inputElement_p) {
        Iterator iterator;
        DecompositionItem item;
        if (inputElement_p instanceof DecompositionModel) {
            return new DecompositionComponent[]{((DecompositionModel)inputElement_p).getSourceComponent()};
        }
        if (inputElement_p instanceof DecompositionComponent) {
            return this.getFilteredItems((DecompositionComponent)inputElement_p).toArray();
        }
        if (inputElement_p instanceof Decomposition) {
            return ((Decomposition)inputElement_p).getTargetComponents().toArray();
        }
        if (inputElement_p instanceof DecompositionItem && this.isSynthesisCheckPage() && (item = (DecompositionItem)inputElement_p).getStatus() != 1) {
            return item.getMessages().toArray();
        }
        if (inputElement_p instanceof List && (iterator = ((List)inputElement_p).iterator()).hasNext()) {
            Object obj = iterator.next();
            return this.getElements(obj);
        }
        return null;
    }

    public Object[] getChildren(Object parentElement_p) {
        if (parentElement_p instanceof DecompositionComponent) {
            return this.getFilteredItems((DecompositionComponent)parentElement_p).toArray();
        }
        if (parentElement_p instanceof Decomposition) {
            return ((Decomposition)parentElement_p).getTargetComponents().toArray();
        }
        if (parentElement_p instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)parentElement_p;
            return item.getServiceItems().toArray();
        }
        return null;
    }

    public Object getParent(Object element_p) {
        if (element_p instanceof DecompositionComponent) {
            if (((DecompositionComponent)element_p).isSourceComponent()) {
                return element_p;
            }
            return ((DecompositionComponent)element_p).getParentDecomposition();
        }
        if (element_p instanceof Decomposition) {
            return ((Decomposition)element_p).getDecompositionModel();
        }
        if (element_p instanceof DecompositionItem) {
            return ((DecompositionItem)element_p).getParentComponent();
        }
        if (element_p instanceof DecompositionItemService) {
            return ((DecompositionItemService)element_p).getParentDecompositionItem();
        }
        return null;
    }

    public boolean hasChildren(Object element_p) {
        if (element_p instanceof DecompositionComponent) {
            return !this.getFilteredItems((DecompositionComponent)element_p).isEmpty();
        }
        if (element_p instanceof Decomposition) {
            return !((Decomposition)element_p).getTargetComponents().isEmpty();
        }
        if (element_p instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)element_p;
            return !item.getServiceItems().isEmpty();
        }
        return false;
    }

    public boolean isSynthesisCheckPage() {
        return this.synthesisCheckPage;
    }

    public void setSynthesisCheckPage(boolean synthesisCheckPage_p) {
        this.synthesisCheckPage = synthesisCheckPage_p;
    }
}

