/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;

public class CapellaShadedNonValidElementLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IColorProvider,
IFontProvider {
    protected Font font = new Font((Device)Display.getDefault(), "Arial", 9, 2);
    protected Color invalidColor = Display.getDefault().getSystemColor(16);
    protected Color validColor = Display.getDefault().getSystemColor(2);
    protected boolean isValidElementsSet = false;
    protected List<EObject> validElements = new ArrayList<EObject>(0);

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.dispose();
    }

    public String getText(Object element) {
        Map.Entry entry;
        EObject key;
        if (element instanceof AbstractNamedElement) {
            String elementName = ((AbstractNamedElement)element).getName();
            if (element instanceof Part) {
                String typeName;
                Part partEle = (Part)element;
                AbstractType abstractType = partEle.getAbstractType();
                elementName = abstractType != null ? ((typeName = abstractType.getName()) != null ? String.valueOf(elementName) + ": " + typeName : String.valueOf(elementName) + ": <undefined>") : String.valueOf(elementName) + ": <undefined>";
            } else if (element instanceof Operation) {
                Operation operation = (Operation)element;
                EList parameters = operation.getOwnedParameters();
                if (!parameters.isEmpty()) {
                    elementName = String.valueOf(elementName) + "(";
                    Iterator iter = parameters.iterator();
                    while (iter.hasNext()) {
                        Parameter parameter = (Parameter)iter.next();
                        elementName = String.valueOf(elementName) + " " + parameter.getName();
                        if (!iter.hasNext()) continue;
                        elementName = String.valueOf(elementName) + ",";
                    }
                    elementName = String.valueOf(elementName) + " )";
                } else {
                    elementName = String.valueOf(elementName) + " ()";
                }
            }
            return elementName;
        }
        if (element instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element).getValue()) != null && key instanceof AbstractNamedElement) {
            return ((AbstractNamedElement)key).getName();
        }
        return super.getText(element);
    }

    public Font getFont(Object element) {
        Map.Entry entry;
        EObject key;
        if (element instanceof AbstractNamedElement ? this.isValidElementsSet && !this.validElements.contains(element) : element instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element).getValue()) instanceof AbstractNamedElement && this.isValidElementsSet && !this.validElements.contains(key)) {
            return this.font;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Map.Entry entry;
        EObject key;
        if (element instanceof AbstractNamedElement) {
            return this.getValidForeGround(element);
        }
        if (element instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element).getValue()) != null && key instanceof AbstractNamedElement) {
            return this.getValidForeGround(key);
        }
        return this.validColor;
    }

    protected Color getValidForeGround(Object element) {
        if (this.isValidElementsSet && !this.validElements.contains(element)) {
            return this.invalidColor;
        }
        return this.validColor;
    }

    public List<EObject> get_notValidList() {
        return this.validElements;
    }

    public void set_ValidList(List<EObject> validList) {
        this.isValidElementsSet = true;
        this.validElements = validList;
    }

    public Image getImage(Object element) {
        Map.Entry entry;
        EObject key;
        if (element instanceof AbstractNamedElement) {
            return super.getImage(element);
        }
        if (element instanceof Map.Entry && (key = (EObject)(entry = (Map.Entry)element).getValue()) != null && key instanceof AbstractNamedElement) {
            return super.getImage((Object)key);
        }
        return super.getImage(element);
    }
}

