/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

public class ZipFileUtil {
    /*
     * Unable to fully structure code
     */
    public static List<File> unzipFiles(File zippedfile, String destPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        var3_3 = null;
        var4_5 = null;
        try {
            zipFile = new ZipFile(zippedfile);
            try {
                entries = zipFile.entries();
                outputFiles = new ArrayList<File>();
                destinationFile = new File(destPath);
                if (!destinationFile.exists()) {
                    destinationFile.mkdirs();
                }
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    outputFile = new File(destinationFile, entry.getName());
                    if (entry.isDirectory() && !outputFile.exists()) {
                        outputFile.mkdirs();
                        continue;
                    }
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    var11_13 = null;
                    var12_15 = null;
                    try {
                        inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                        try {
                            outStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                            try {
                                ZipFileUtil.copyStream(inputStream, outStream);
                            }
                            finally {
                                if (outStream != null) {
                                    outStream.close();
                                }
                            }
                            ** if (inputStream == null) goto lbl-1000
                        }
                        catch (Throwable var12_16) {
                            if (var11_13 == null) {
                                var11_13 = var12_16;
                            } else if (var11_13 != var12_16) {
                                var11_13.addSuppressed(var12_16);
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw var11_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            inputStream.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var12_17) {
                        if (var11_13 == null) {
                            var11_13 = var12_17;
                        } else if (var11_13 != var12_17) {
                            var11_13.addSuppressed(var12_17);
                        }
                        throw var11_13;
                    }
                    outputFiles.add(outputFile);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                return outputFiles;
            }
            catch (Throwable var3_4) {
                throw var3_4;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int readCount;
        Assert.isNotNull((Object)in);
        Assert.isNotNull((Object)out);
        byte[] buffer = new byte[4096];
        while ((readCount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readCount);
        }
        out.flush();
    }

    public static void createZipFile(File zipFile, List<File> files) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, null);
    }

    public static void createZipFile(File zipFile, List<File> files, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, monitor);
    }

    public static void createZipFile(File zipFile, List<File> files, String rootPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (rootPath == null) {
            rootPath = "";
        } else if (!rootPath.endsWith("\\") || !rootPath.endsWith("/")) {
            rootPath = String.valueOf(rootPath) + "/";
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            for (File file : files) {
                try {
                    ZipFileUtil.addZipEntry(zipOut, rootPath, file);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", "Could not add " + file.getName() + " to zip", (Throwable)e));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addZipEntry(ZipOutputStream zipOut, String rootPath, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    ZipFileUtil.addZipEntry(zipOut, rootPath, child);
                    ++n2;
                }
            } else {
                String path = "";
                if (!rootPath.equals("")) {
                    rootPath = rootPath.replaceAll("\\\\", "/");
                    path = file.getAbsolutePath().replaceAll("\\\\", "/");
                    path = path.substring(rootPath.length());
                } else {
                    path = file.getName();
                }
                zipOut.putNextEntry(new ZipEntry(path));
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ZipFileUtil.copyStream(in, zipOut);
                }
                zipOut.closeEntry();
            }
        }
    }
}

