/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.viewAndController;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceHelper;
import org.polarsys.capella.core.data.interaction.properties.dialogs.Messages;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.CreationAlgorithms;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class SelectOperationDialogForSharedDataAndEvent
extends SelectElementsDialog {
    private Button _restrictedTreeViewerButton;
    private ViewerFilter _restrictedInterfaceFilter;
    private ViewerFilter _showComponentExchangeFilter;
    private Text _operationText;
    private Text _interfaceText;
    private Button _selectInterfaceButton;
    private Button _enableCreationButton;
    private ElementSupportedType _elementSupportedType;
    private List<? extends EObject> _restrictedElements;
    private Button _createPortsButton;
    private boolean _isPortStrategy;
    private Button _showComponentExchanges;
    private Button _eventRadioButton;
    private Button _flowRadioButton;
    private Button _operationRadioButton;
    private Button _sharedRadioButton;
    private Group _eiTypeGroup;
    private Button _unsetRadioButton;
    private InstanceRole _sourceIR;
    private InstanceRole _targetIR;
    private MessageKind _messageKind;

    public SelectOperationDialogForSharedDataAndEvent(Shell parentShell, String dialogTitle, String dialogMessage, List<? extends EObject> wholeElements, List<? extends EObject> restrictedElements, InstanceRole sourceIR, InstanceRole targetIR, MessageKind messageKind, ElementSupportedType type) {
        super(parentShell, dialogTitle, dialogMessage, wholeElements);
        this._sourceIR = sourceIR;
        this._targetIR = targetIR;
        this._elementSupportedType = type;
        this._restrictedElements = restrictedElements;
        this._messageKind = messageKind;
    }

    private void configureEnableCreationButtonHandler() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectOperationDialogForSharedDataAndEvent.this.updateWindow();
            }
        };
        if (this._enableCreationButton != null) {
            this._enableCreationButton.addSelectionListener((SelectionListener)listener);
            if (this._restrictedElements.size() == 0) {
                this._enableCreationButton.setSelection(true);
            } else {
                this._enableCreationButton.setSelection(false);
            }
        }
        listener.widgetSelected(null);
    }

    void updateWindow() {
        boolean enabledCreationOperation = false;
        boolean enabledCreationInterface = true;
        if (this._enableCreationButton != null) {
            enabledCreationOperation = this._enableCreationButton.getSelection();
            enabledCreationInterface = this._enableCreationButton.getSelection();
        }
        enabledCreationInterface = enabledCreationOperation;
        enabledCreationInterface |= this.getAnExchangeItemSelected() instanceof ExchangeItem;
        if (this._operationText != null) {
            this._eiTypeGroup.setEnabled(enabledCreationInterface);
            this._operationText.setEnabled(enabledCreationOperation);
            this.updateRadioButtons(enabledCreationOperation);
        }
        this._interfaceText.setEnabled(enabledCreationInterface);
        if (this._createPortsButton != null) {
            this._createPortsButton.setEnabled(enabledCreationInterface);
        }
        this._selectInterfaceButton.setEnabled(enabledCreationInterface);
        TreeAndListViewer viewer = this.getViewer();
        ISelection selection = null;
        if (viewer != null) {
            viewer.setEnabled(!enabledCreationOperation);
            selection = viewer.getSelection();
        }
        if (this._restrictedTreeViewerButton != null) {
            this._restrictedTreeViewerButton.setEnabled(!enabledCreationOperation);
        }
        if (this._restrictedTreeViewerButton != null && InterfaceHelper.isSharedDataAccess(this._sourceIR, this._targetIR)) {
            this._restrictedTreeViewerButton.setEnabled(false);
        }
        this.updateButtons(selection);
    }

    private void updateRadioButtons(boolean enabledCreationOperation) {
        if (enabledCreationOperation) {
            if (this._messageKind == MessageKind.ASYNCHRONOUS_CALL) {
                this._eventRadioButton.setEnabled(true);
                this._sharedRadioButton.setEnabled(true);
            } else {
                this._eventRadioButton.setEnabled(false);
                this._sharedRadioButton.setEnabled(false);
            }
            this._flowRadioButton.setEnabled(true);
            this._unsetRadioButton.setEnabled(true);
            this._operationRadioButton.setEnabled(true);
        } else {
            this._eventRadioButton.setEnabled(false);
            this._sharedRadioButton.setEnabled(false);
            this._flowRadioButton.setEnabled(false);
            this._unsetRadioButton.setEnabled(false);
            this._operationRadioButton.setEnabled(false);
        }
    }

    private List<EObject> getAvailableInterfaces() {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InteractionPackage.Literals.SEQUENCE_MESSAGE, (EStructuralFeature)InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_END);
        return query.getAvailableElements((EObject)this._sourceIR);
    }

    private void configureSelectInterfaceButtonHandler() {
        this._selectInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectElementsDialog selectInterfaceDialog = new SelectElementsDialog(SelectOperationDialogForSharedDataAndEvent.this.getParentShell(), Messages.SelectOperationDialog_SelectInterfaceDialog_Title, Messages.SelectOperationDialog_SelectInterfaceDialog_Message, (Collection)SelectOperationDialogForSharedDataAndEvent.this.getAvailableInterfaces());
                if (selectInterfaceDialog.open() == 0) {
                    AbstractNamedElement selectedInterface = (AbstractNamedElement)selectInterfaceDialog.getResult().get(0);
                    SelectOperationDialogForSharedDataAndEvent.this._interfaceText.setText(selectedInterface.getName());
                    SelectOperationDialogForSharedDataAndEvent.this._interfaceText.setData((Object)selectedInterface);
                }
            }
        });
    }

    private void createCreationOperationPart(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(3, false));
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_CreateNewExchangeItem);
        this._enableCreationButton = new Button((Composite)treeViewerPartGroup, 32);
        this._enableCreationButton.setText(Messages.SelectOperationDialog_EnableCreationButton_Title);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this._enableCreationButton.setLayoutData((Object)layoutData);
        this.createLabel((Composite)treeViewerPartGroup, Messages.SelectOperationDialog_Operation_Title);
        this._operationText = this.createText((Composite)treeViewerPartGroup);
        ((GridData)this._operationText.getLayoutData()).horizontalSpan = 3;
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectOperationDialogForSharedDataAndEvent.this.updateButtons(null);
            }
        };
        this._operationText.addModifyListener(modifyListener);
        this._eiTypeGroup = new Group((Composite)treeViewerPartGroup, 0);
        this._eiTypeGroup.setText(Messages.SelectOperationDialog_2);
        this._eiTypeGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        this._eiTypeGroup.setLayout((Layout)new GridLayout(5, false));
        this._eventRadioButton = new Button((Composite)this._eiTypeGroup, 16);
        this._eventRadioButton.setText(Messages.SelectOperationDialog_3);
        this._flowRadioButton = new Button((Composite)this._eiTypeGroup, 16);
        this._flowRadioButton.setText(Messages.SelectOperationDialog_4);
        this._operationRadioButton = new Button((Composite)this._eiTypeGroup, 16);
        this._operationRadioButton.setText(Messages.SelectOperationDialog_5);
        this._operationRadioButton.setEnabled(true);
        this._operationRadioButton.setSelection(true);
        this._sharedRadioButton = new Button((Composite)this._eiTypeGroup, 16);
        this._sharedRadioButton.setText(Messages.SelectOperationDialog_6);
        this._unsetRadioButton = new Button((Composite)this._eiTypeGroup, 16);
        this._unsetRadioButton.setText(Messages.SelectOperationDialog_7);
    }

    private void createInterfacePart(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_CreateOrSelectInterface);
        treeViewerPartGroup.setLayoutData((Object)new GridData(4, 1, true, true));
        treeViewerPartGroup.setLayout((Layout)new GridLayout(3, false));
        this.createLabel((Composite)treeViewerPartGroup, Messages.SelectOperationDialog_Interface_Title);
        this._interfaceText = this.createText((Composite)treeViewerPartGroup);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectOperationDialogForSharedDataAndEvent.this.updateButtons(null);
            }
        };
        this._interfaceText.addModifyListener(modifyListener);
        this._selectInterfaceButton = new Button((Composite)treeViewerPartGroup, 8);
        this._selectInterfaceButton.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.browse"));
        List<EObject> accessiblesInterfaces = this.getAvailableInterfaces();
        Interface bestInterface = null;
        boolean multipleBest = false;
        for (EObject capellaElement : accessiblesInterfaces) {
            if (!this.isGoodInterface(capellaElement)) continue;
            if (bestInterface != null) {
                multipleBest = true;
                break;
            }
            bestInterface = (Interface)capellaElement;
        }
        if (bestInterface == null) {
            StringBuilder builder = new StringBuilder();
            if (this._sourceIR != null && this._sourceIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
                builder.append(this._sourceIR.getName());
                builder.append("_Interface");
            } else if (this._targetIR != null && this._targetIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
                builder.append(this._targetIR.getName());
                builder.append("_Interface");
            } else {
                AbstractType abstractType;
                if (this._sourceIR != null && this._sourceIR.getRepresentedInstance() != null) {
                    abstractType = this._sourceIR.getRepresentedInstance().getAbstractType();
                    if (abstractType != null) {
                        builder.append(abstractType.getName());
                    } else {
                        builder.append(this._sourceIR.getName());
                    }
                }
                if (this._sourceIR != null && this._targetIR != null) {
                    builder.append("_to_");
                }
                if (this._targetIR != null && this._targetIR.getRepresentedInstance() != null) {
                    abstractType = this._targetIR.getRepresentedInstance().getAbstractType();
                    if (abstractType != null) {
                        builder.append(abstractType.getName());
                    } else {
                        builder.append(this._targetIR.getName());
                    }
                }
            }
            this._interfaceText.setText(builder.toString());
        } else if (multipleBest) {
            this._interfaceText.setData(null);
            this._interfaceText.setText("");
        } else {
            this._interfaceText.setData(bestInterface);
            this._interfaceText.setText(bestInterface.getName());
            if (InterfaceHelper.isSharedDataAccess(this._sourceIR, this._targetIR)) {
                this._interfaceText.setEnabled(false);
            }
        }
    }

    private boolean isGoodInterface(EObject capellaElement) {
        Interface interf = (Interface)capellaElement;
        AbstractType src = this._sourceIR == null ? null : this._sourceIR.getRepresentedInstance().getAbstractType();
        AbstractType tgt = this._targetIR == null ? null : this._targetIR.getRepresentedInstance().getAbstractType();
        Component srcComp = null;
        Component tgtComp = null;
        ExchangeItem ei = null;
        if (src instanceof Component) {
            srcComp = (Component)src;
        } else {
            ei = (ExchangeItem)src;
        }
        if (tgt instanceof Component) {
            tgtComp = (Component)tgt;
        } else {
            ei = (ExchangeItem)tgt;
        }
        if (ei == null) {
            return ComponentExt.isImplementingInterface((Component)tgtComp, (Interface)interf) && ComponentExt.isUsingInterface((Component)srcComp, (Interface)interf);
        }
        for (ExchangeItemAllocation eia : interf.getOwnedExchangeItemAllocations()) {
            if (eia.getAllocatedItem() != ei) continue;
            return true;
        }
        return false;
    }

    private void createCreatePortButton(Composite parent) {
        this._createPortsButton = new Button(parent, 32);
        this._createPortsButton.setText(Messages.SelectOperationDialog_0);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.horizontalSpan = 3;
        this._createPortsButton.setLayoutData((Object)layoutData);
    }

    private Interface getOrCreateInterface() {
        Interface selectedInterface = (Interface)this._interfaceText.getData();
        if (selectedInterface == null || !selectedInterface.getName().equals(this._interfaceText.getText())) {
            selectedInterface = CreationAlgorithms.INSTANCE.createInterface(this._interfaceText.getText(), this._sourceIR, this._targetIR, false);
            this._interfaceText.setData((Object)selectedInterface);
        }
        return selectedInterface;
    }

    private ExchangeItem createExchangeItem() {
        ExchangeItem result = InformationFactory.eINSTANCE.createExchangeItem();
        Interface itf = this.getOrCreateInterface();
        EObject container = itf.eContainer();
        if (container instanceof InterfacePkg) {
            InterfacePkg ipkg = (InterfacePkg)container;
            ipkg.getOwnedExchangeItems().add((Object)result);
        } else {
            InterfaceExt.getRootOwnerInterfacePkg((Interface)itf).getOwnedExchangeItems().add((Object)result);
        }
        result.setExchangeMechanism(ExchangeMechanism.OPERATION);
        if (this._operationRadioButton.getSelection()) {
            result.setExchangeMechanism(ExchangeMechanism.OPERATION);
        }
        if (this._eventRadioButton.getSelection()) {
            result.setExchangeMechanism(ExchangeMechanism.EVENT);
        }
        if (this._sharedRadioButton.getSelection()) {
            result.setExchangeMechanism(ExchangeMechanism.SHARED_DATA);
        }
        if (this._flowRadioButton.getSelection()) {
            result.setExchangeMechanism(ExchangeMechanism.FLOW);
        }
        if (this._unsetRadioButton.getSelection()) {
            result.setExchangeMechanism(ExchangeMechanism.UNSET);
        }
        CapellaElementExt.creationService((EObject)result);
        result.setName(this._operationText.getText());
        return result;
    }

    private ExchangeItemAllocation allocateExchangeItem(ExchangeItem exchangeItem) {
        Interface selectedInterface = this.getOrCreateInterface();
        ExchangeItemAllocation result = InterfaceExt.addExchangeItem((Interface)selectedInterface, (ExchangeItem)exchangeItem);
        if (this._operationText == null) {
            return this.allocateExchangeItemForSharedData(exchangeItem, result);
        }
        if (this._messageKind == MessageKind.SYNCHRONOUS_CALL) {
            result.setSendProtocol(CommunicationLinkProtocol.SYNCHRONOUS);
        }
        if (this._messageKind == MessageKind.ASYNCHRONOUS_CALL) {
            result.setSendProtocol(CommunicationLinkProtocol.ASYNCHRONOUS);
        }
        if (this._messageKind == MessageKind.CREATE) {
            result.setSendProtocol(CommunicationLinkProtocol.BROADCAST);
        }
        return result;
    }

    private ExchangeItemAllocation allocateExchangeItemForSharedData(ExchangeItem exchangeItem, ExchangeItemAllocation result) {
        Component component;
        ExchangeItem ei;
        CommunicationLink communicationLink = null;
        if (this._sourceIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
            ei = (ExchangeItem)this._sourceIR.getRepresentedInstance().getAbstractType();
            component = (Component)this._targetIR.getRepresentedInstance().getAbstractType();
        } else {
            component = (Component)this._sourceIR.getRepresentedInstance().getAbstractType();
            ei = (ExchangeItem)this._targetIR.getRepresentedInstance().getAbstractType();
        }
        for (CommunicationLink cl : CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)component)) {
            if (cl.getExchangeItem() != ei) continue;
            communicationLink = cl;
            break;
        }
        if (communicationLink == null) {
            if (this._messageKind == MessageKind.CREATE) {
                result.setReceiveProtocol(CommunicationLinkProtocol.UNSET);
            } else if (this._messageKind == MessageKind.SYNCHRONOUS_CALL) {
                if (ei.getExchangeMechanism() == ExchangeMechanism.SHARED_DATA) {
                    result.setReceiveProtocol(CommunicationLinkProtocol.READ);
                }
            } else if (this._messageKind == MessageKind.ASYNCHRONOUS_CALL && this._sourceIR.getRepresentedInstance().getAbstractType() instanceof ExchangeItem) {
                result.setReceiveProtocol(CommunicationLinkProtocol.ACCEPT);
            }
        } else {
            CommunicationLinkKind communicationLinkKind = communicationLink.getKind();
            CommunicationLinkProtocol communicationLinkProtocol = communicationLink.getProtocol();
            if (CommunicationLinkKind.SEND == communicationLinkKind || CommunicationLinkKind.PRODUCE == communicationLinkKind || CommunicationLinkKind.CALL == communicationLinkKind || CommunicationLinkKind.WRITE == communicationLinkKind || CommunicationLinkKind.TRANSMIT == communicationLinkKind) {
                result.setSendProtocol(communicationLinkProtocol);
            } else if (CommunicationLinkKind.RECEIVE == communicationLinkKind || CommunicationLinkKind.CONSUME == communicationLinkKind || CommunicationLinkKind.EXECUTE == communicationLinkKind || CommunicationLinkKind.ACCESS == communicationLinkKind || CommunicationLinkKind.ACQUIRE == communicationLinkKind) {
                result.setReceiveProtocol(communicationLinkProtocol);
            }
        }
        return result;
    }

    private void createRestrictedTreeViewerButton(Composite parent) {
        this._restrictedInterfaceFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ExchangeItemAllocation || element instanceof ExchangeItem) {
                    return SelectOperationDialogForSharedDataAndEvent.this._restrictedElements.contains(element);
                }
                if (element instanceof AbstractEventOperation) {
                    return true;
                }
                if (element instanceof CapellaElement) {
                    TreeIterator iterator = ((CapellaElement)element).eAllContents();
                    while (iterator.hasNext()) {
                        EObject obj = (EObject)iterator.next();
                        if (!SelectOperationDialogForSharedDataAndEvent.this._restrictedElements.contains(obj)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
        this._restrictedTreeViewerButton = new Button(parent, 32);
        this._restrictedTreeViewerButton.setText(Messages.SelectOperationDialog_RestrictedInterfacesButton_Title);
        this._restrictedTreeViewerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    if (SelectOperationDialogForSharedDataAndEvent.this._restrictedInterfaceFilter != null) {
                        SelectOperationDialogForSharedDataAndEvent.this.getViewer().getClientViewer().addFilter(SelectOperationDialogForSharedDataAndEvent.this._restrictedInterfaceFilter);
                    }
                } else if (SelectOperationDialogForSharedDataAndEvent.this._restrictedInterfaceFilter != null) {
                    SelectOperationDialogForSharedDataAndEvent.this.getViewer().getClientViewer().removeFilter(SelectOperationDialogForSharedDataAndEvent.this._restrictedInterfaceFilter);
                }
            }
        });
        this._restrictedTreeViewerButton.setSelection(true);
        this.getViewer().getClientViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectOperationDialogForSharedDataAndEvent.this.updateWindow();
            }
        });
        this.getViewer().getClientViewer().addFilter(this._restrictedInterfaceFilter);
    }

    protected int getTreeViewerStyle() {
        return 2;
    }

    protected void createTreeViewerPart(Composite parent) {
        Group treeViewerPartGroup = new Group(parent, 0);
        treeViewerPartGroup.setText(Messages.SelectOperationDialog_SelectExistingOperationGroup_Title);
        treeViewerPartGroup.setLayout((Layout)new GridLayout());
        treeViewerPartGroup.setLayoutData((Object)new GridData(1808));
        super.createTreeViewerPart((Composite)treeViewerPartGroup);
        if (this._elementSupportedType == ElementSupportedType.OPERATION) {
            this.createRestrictedTreeViewerButton(this.getViewer().getControl());
        }
    }

    protected void doCreateDialogArea(Composite parent) {
        if (this._elementSupportedType == ElementSupportedType.OPERATION) {
            if (!InterfaceHelper.isSharedDataAccess(this._sourceIR, this._targetIR)) {
                this.createCreationOperationPart(parent);
            }
            this.createInterfacePart(parent);
            super.doCreateDialogArea(parent);
            this.createShowCEButton(parent);
            this.configureSelectInterfaceButtonHandler();
            this.createCreatePortButton(parent);
            this.configureEnableCreationButtonHandler();
        } else {
            super.doCreateDialogArea(parent);
        }
    }

    private void createShowCEButton(Composite parent) {
        this._showComponentExchangeFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ExchangeItemAllocation) {
                    return true;
                }
                if (element instanceof AbstractEventOperation) {
                    return SelectOperationDialogForSharedDataAndEvent.this._restrictedElements.contains(element);
                }
                if (element instanceof CapellaElement) {
                    TreeIterator iterator = ((CapellaElement)element).eAllContents();
                    while (iterator.hasNext()) {
                        EObject obj = (EObject)iterator.next();
                        if (!SelectOperationDialogForSharedDataAndEvent.this._restrictedElements.contains(obj)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
        this._showComponentExchanges = new Button(this.getViewer().getControl(), 32);
        this._showComponentExchanges.setText(Messages.SelectOperationDialog_1);
        this._showComponentExchanges.setSelection(true);
        this._showComponentExchanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    if (SelectOperationDialogForSharedDataAndEvent.this._showComponentExchangeFilter != null) {
                        SelectOperationDialogForSharedDataAndEvent.this.getViewer().getClientViewer().removeFilter(SelectOperationDialogForSharedDataAndEvent.this._showComponentExchangeFilter);
                    }
                } else if (SelectOperationDialogForSharedDataAndEvent.this._showComponentExchangeFilter != null) {
                    SelectOperationDialogForSharedDataAndEvent.this.getViewer().getClientViewer().addFilter(SelectOperationDialogForSharedDataAndEvent.this._showComponentExchangeFilter);
                }
            }
        });
    }

    public void create() {
        super.create();
        this.getShell().setMinimumSize(661, 800);
    }

    protected List<? extends EObject> handleResult() {
        CapellaElement getAnExchangeItemSelected = this.getAnExchangeItemSelected();
        this._isPortStrategy = this._createPortsButton.getSelection();
        if (this._elementSupportedType == ElementSupportedType.EXCHANGE || this._enableCreationButton != null && !this._enableCreationButton.getSelection() && getAnExchangeItemSelected == null) {
            return super.handleResult();
        }
        if (getAnExchangeItemSelected instanceof ExchangeItemAllocation && (this._enableCreationButton == null || !this._enableCreationButton.getSelection())) {
            return Collections.singletonList(getAnExchangeItemSelected);
        }
        ExchangeItemAllocation allocation = getAnExchangeItemSelected != null && (this._enableCreationButton == null || !this._enableCreationButton.getSelection()) ? this.allocateExchangeItem((ExchangeItem)getAnExchangeItemSelected) : this.allocateExchangeItem(this.createExchangeItem());
        return Collections.singletonList(allocation);
    }

    private CapellaElement getAnExchangeItemSelected() {
        if (this.getViewer() == null) {
            return null;
        }
        ISelection selection = this.getViewer().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        Object selectionItem = ((TreeSelection)selection).getFirstElement();
        if (selectionItem == null) {
            return null;
        }
        if (selectionItem instanceof ExchangeItem) {
            return (ExchangeItem)selectionItem;
        }
        if (selectionItem instanceof ExchangeItemAllocation) {
            return (ExchangeItemAllocation)selectionItem;
        }
        return null;
    }

    protected boolean isOkToClose(ISelection selection) {
        boolean operationSet;
        CapellaElement getAnExchangeItemSelected = this.getAnExchangeItemSelected();
        if (this._elementSupportedType == ElementSupportedType.EXCHANGE || this._enableCreationButton != null && !this._enableCreationButton.getSelection() && getAnExchangeItemSelected == null) {
            return super.isOkToClose(selection);
        }
        boolean interfaceSet = !this._interfaceText.getText().equals("");
        boolean exchangeItemSelected = getAnExchangeItemSelected instanceof ExchangeItem;
        boolean exchangeItemAllocationSelected = getAnExchangeItemSelected instanceof ExchangeItemAllocation;
        boolean bl = operationSet = this._operationText != null && !this._operationText.getText().equals("");
        if (exchangeItemAllocationSelected) {
            return true;
        }
        if (exchangeItemSelected) {
            return interfaceSet;
        }
        return interfaceSet && operationSet;
    }

    public boolean isPortStrategy() {
        return this._isPortStrategy;
    }

    public static enum ElementSupportedType {
        OPERATION,
        EXCHANGE;

    }
}

