/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.sections;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.properties.Messages;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_AvailableInStatesController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_InvolvedFunctionalChainsController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_InvolvedFunctionsController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_RealizedCapabilitiesController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_SuperController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.CompositionMultipleSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ConstraintReferenceGroup;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public abstract class AbstractCapabilitySection
extends NamedElementSection {
    private CompositionMultipleSemanticField superTypes;
    private MultipleSemanticField realizedFunctionsField;
    private MultipleSemanticField realizedFunctionalChainsField;
    private MultipleSemanticField availableInStatesField;
    private MultipleSemanticField realizedCapabilitiesField;
    private ConstraintReferenceGroup prePostConditions;
    private boolean showRealizedCapabilitiesField;

    public AbstractCapabilitySection() {
        this(true);
    }

    public AbstractCapabilitySection(boolean showRealizedCapabilitiesField) {
        this.showRealizedCapabilitiesField = showRealizedCapabilitiesField;
    }

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        this.prePostConditions = new ConstraintReferenceGroup((Map)ImmutableMap.of((Object)Messages.getString("AbstractCapabilitySection_PreCondition_Label"), (Object)InteractionPackage.Literals.ABSTRACT_CAPABILITY__PRE_CONDITION, (Object)Messages.getString("AbstractCapabilitySection_PostCondition_Label"), (Object)InteractionPackage.Literals.ABSTRACT_CAPABILITY__POST_CONDITION));
        this.prePostConditions.createControls(parent, this.getWidgetFactory(), this.isDisplayedInWizard());
        this.superTypes = new CompositionMultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_SuperType_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_SuperController());
        this.superTypes.setDisplayedInWizard(this.isDisplayedInWizard());
        this.realizedFunctionsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), this.getInvolvedFunctionsLabel(), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_InvolvedFunctionsController());
        this.realizedFunctionsField.setDisplayedInWizard(this.isDisplayedInWizard());
        this.realizedFunctionalChainsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), this.getInvolvedFunctionalChainsLabel(), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_InvolvedFunctionalChainsController());
        this.realizedFunctionalChainsField.setDisplayedInWizard(this.isDisplayedInWizard());
        this.availableInStatesField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_AvailableInStates_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_AvailableInStatesController());
        this.availableInStatesField.setDisplayedInWizard(this.isDisplayedInWizard());
        if (this.showRealizedCapabilitiesField) {
            this.realizedCapabilitiesField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_RealizedCapabilities_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_RealizedCapabilitiesController());
            this.realizedCapabilitiesField.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    protected String getInvolvedFunctionsLabel() {
        return Messages.getString("AbstractCapabilitySection_RealizedFunctions_Label");
    }

    protected String getInvolvedFunctionalChainsLabel() {
        return Messages.getString("AbstractCapabilitySection_RealizedFunctionalChains_Label");
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.prePostConditions.loadData(capellaElement);
        if (this.superTypes != null) {
            this.superTypes.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_Super(), (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_SuperGeneralizations());
        }
        if (this.availableInStatesField != null) {
            this.availableInStatesField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_AvailableInStates());
        }
        if (this.realizedFunctionsField != null) {
            this.realizedFunctionsField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedAbstractFunctionAbstractCapabilityInvolvements());
        }
        if (this.realizedFunctionalChainsField != null) {
            this.realizedFunctionalChainsField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedFunctionalChainAbstractCapabilityInvolvements());
        }
        if (this.realizedCapabilitiesField != null) {
            this.realizedCapabilitiesField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedAbstractCapabilityRealizations());
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.superTypes);
        fields.add((AbstractSemanticField)this.availableInStatesField);
        fields.add((AbstractSemanticField)this.realizedFunctionsField);
        fields.add((AbstractSemanticField)this.realizedFunctionalChainsField);
        if (this.realizedCapabilitiesField != null) {
            fields.add((AbstractSemanticField)this.realizedCapabilitiesField);
        }
        fields.addAll(this.prePostConditions.getFields());
        return fields;
    }
}

