/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.capella.common.ui.MdeCommonUiActivator;
import org.polarsys.capella.common.ui.preferences.Messages;

public class ExportCSVPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor otherFieldEditor;
    private boolean otherEnabled = false;

    public ExportCSVPreferencePage() {
        super(1);
        this.setTitle(Messages.ExportCSVPreferencePage_Title);
        this.setDescription(Messages.ExportCSVPreferencePage_Description);
    }

    protected void createFieldEditors() {
        final Composite parent = this.getFieldEditorParent();
        this.otherEnabled = this.getPreferenceStore().getString("delimiter").equals("other");
        RadioGroupFieldEditor groupRadios = new RadioGroupFieldEditor("delimiter", Messages.ExportCSVPreferencePage_Delimiters, 1, new String[][]{{"tab", "tab"}, {"semicolon", "semicolon"}, {"comma", "comma"}, {"space", "space"}, {"other", "other"}}, parent, false){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                super.fireValueChanged(property, oldValue, newValue);
                if (newValue.toString().equals("other")) {
                    ExportCSVPreferencePage.this.otherFieldEditor.setEnabled(true, parent);
                    ExportCSVPreferencePage.this.otherEnabled = true;
                    ExportCSVPreferencePage.this.otherFieldEditor.setErrorMessage(Messages.ExportCSVPreferencePage_ErrorMessage);
                    ExportCSVPreferencePage.this.otherFieldEditor.getTextControl(parent).setText("");
                } else {
                    ExportCSVPreferencePage.this.otherFieldEditor.setEnabled(false, parent);
                    ExportCSVPreferencePage.this.otherEnabled = false;
                    ExportCSVPreferencePage.this.otherFieldEditor.loadDefault();
                }
            }
        };
        this.addField((FieldEditor)groupRadios);
        this.otherFieldEditor = new StringFieldEditor("other", "", 10, parent){

            protected boolean doCheckState() {
                String txt = this.getTextControl().getText();
                boolean restoreDefaults = txt.equals("");
                if (restoreDefaults) {
                    this.setEnabled(false, parent);
                    ExportCSVPreferencePage.this.otherFieldEditor.getTextControl(parent).setText("");
                    ExportCSVPreferencePage.this.otherEnabled = false;
                }
                return !ExportCSVPreferencePage.this.otherEnabled || restoreDefaults || txt != null && txt.length() == 1;
            }
        };
        if (!this.otherEnabled) {
            this.otherFieldEditor.setEnabled(false, parent);
            this.otherFieldEditor.loadDefault();
        }
        this.addField((FieldEditor)this.otherFieldEditor);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(MdeCommonUiActivator.getDefault().getPreferenceStore());
    }
}

