/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.helpers.export.DataExporter;
import org.polarsys.capella.common.helpers.export.IExporterProvider;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.ExporterProvider;
import org.polarsys.capella.common.ui.toolkit.dialogs.IExportConstants;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractRegExpViewer;

public abstract class AbstractExportDialog
extends AbstractViewerDialog {
    private static final int EXPORT_ID = -100;
    private Object _data;
    private Viewer _viewer;
    private AbstractContextMenuFiller _contextMenuManagerFiller;
    private ExporterProvider _exporterProvider;

    private ExporterProvider getExporterProvider() {
        if (this._exporterProvider == null) {
            this._exporterProvider = new ExporterProvider();
        }
        return this._exporterProvider;
    }

    public AbstractExportDialog(Shell parentShell, String title, String message, String shellTitle) {
        super(parentShell, title, message, shellTitle);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -100, Messages.exportButtonLabel, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (-100 == buttonId) {
            this.exportPressed();
        } else if (12 == buttonId) {
            this.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void exportPressed() {
        DataExporter dataExporter = new DataExporter((IExporterProvider)this.getExporterProvider());
        FileDialog fd = new FileDialog(this.getParentShell(), 8192);
        fd.setText(Messages.fileBrowserDialogTitle);
        fd.setFilterExtensions(dataExporter.getSupportedExtension());
        fd.setFilterNames(dataExporter.getSupportedDescription());
        String fileName = fd.open();
        if (fileName != null) {
            boolean result = dataExporter.exportToFile(fileName, this.getExportableData());
            if (result) {
                MessageDialog.openInformation((Shell)this.getParentShell(), (String)Messages.exportMetrics, (String)NLS.bind((String)Messages.exportOk, (Object)fileName));
            } else {
                MessageDialog.openError((Shell)this.getParentShell(), (String)Messages.exportMetrics, (String)NLS.bind((String)Messages.exportKo, (Object)fileName));
            }
        }
    }

    protected abstract List<String[]> getExportableData();

    protected List<String[]> getExportableData(String str) {
        Date date = new Date();
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(new String[]{NLS.bind((String)Messages.exportRootFileNameLabel, (Object)str)});
        result.add(new String[]{NLS.bind((String)Messages.exportDateLabel, (Object)date)});
        result.add(IExportConstants.EXPORT_EMPTY_LINE);
        result.add(IExportConstants.EXPORT_EMPTY_LINE);
        return result;
    }

    public void setData(Object data) {
        this._data = data;
        if (this._viewer != null) {
            this._viewer.setInput(this._data);
        }
    }

    public Object getData() {
        return this._data;
    }

    public void setContextMenuManagerFiller(AbstractContextMenuFiller filler) {
        this._contextMenuManagerFiller = filler;
    }

    @Override
    protected void doCreateDialogArea(Composite parent) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        parent.setLayoutData((Object)gridData);
        AbstractRegExpViewer abstractViewer = this.createViewer(parent);
        if (this._contextMenuManagerFiller != null) {
            abstractViewer.setContextMenuManagerFiller(this._contextMenuManagerFiller);
        }
        this._viewer = abstractViewer.getClientViewer();
        this._viewer.setInput(this._data);
        this._viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected abstract AbstractRegExpViewer createViewer(Composite var1);

    @Override
    protected Object getResult() {
        return null;
    }

    protected Viewer getViewer() {
        return this._viewer;
    }
}

