/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.ui.metric.core.IMetricFilter;

public class Metric<T> {
    Set<IMetricFilter> filters;
    Map<T, Integer> result = new HashMap<T, Integer>();

    public Metric() {
        this.filters = new HashSet<IMetricFilter>();
    }

    public Metric(Set<T> targets) {
        this();
        if (targets != null) {
            for (T current : targets) {
                this.result.put(current, 0);
            }
        }
    }

    public Map<T, Integer> getResult() {
        return this.result;
    }

    public void addFilter(IMetricFilter filter) {
        this.filters.add(filter);
    }

    public boolean accept(EObject eObject) {
        for (IMetricFilter filter : this.filters) {
            if (filter.accept(eObject)) continue;
            return false;
        }
        return true;
    }

    public void update(T key) {
        int i = 1;
        if (this.result.containsKey(key)) {
            i += this.result.get(key).intValue();
        }
        this.result.put(key, i);
    }
}

