/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.dialog;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.ui.metric.core.MetricTree;

public class MetricLabelProvider
extends CreateOrSelectElementCommand.LabelProvider
implements ITableLabelProvider {
    protected static final String REGEX = "\\[|(\\].*)";
    public static final int OBJ_COLUMN_INDEX = 0;
    public static final int QTY_COLUMN_INDEX = 1;
    private static AdapterFactory capellaAdapterFactory = CapellaAdapterFactoryProvider.getInstance().getAdapterFactory();

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.getImage(element);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        switch (columnIndex) {
            case 0: {
                text = this.getText(element);
                break;
            }
            case 1: {
                MetricTree metricTreeNode = (MetricTree)element;
                int count = metricTreeNode.getCount();
                if (count <= 0) break;
                text = Integer.toString(count);
                break;
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        MetricTree metricTreeNode = (MetricTree)element;
        EObject eobject = (EObject)metricTreeNode.getElement();
        IItemLabelProvider itemProvider = (IItemLabelProvider)capellaAdapterFactory.adapt((Notifier)eobject, IItemLabelProvider.class);
        if (itemProvider != null) {
            return ExtendedImageRegistry.getInstance().getImage(itemProvider.getImage((Object)eobject));
        }
        return null;
    }

    public String getText(Object element) {
        MetricTree metricTreeNode = (MetricTree)element;
        EObject eObject = (EObject)metricTreeNode.getElement();
        String text = "";
        IItemLabelProvider itemProvider = (IItemLabelProvider)capellaAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemProvider != null) {
            text = itemProvider.getText((Object)eObject);
        }
        if (text == null || text.isEmpty() || "[]".equals(text.trim()) || "[null]".equals(text.trim()) || "null".equals(text.trim())) {
            text = EObjectLabelProviderHelper.getMetaclassLabel((EObject)eObject, (boolean)true);
        }
        return text.replaceAll(REGEX, "");
    }
}

