/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.fa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_ComponentPort_ProvidedInterfaces
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement element = (CapellaElement)input;
        List<Object> availableElements = new ArrayList(1);
        ArrayList<CapellaElement> tempAvailableElements = new ArrayList<CapellaElement>(1);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        if (element instanceof Port) {
            Port ele = (Port)element;
            tempAvailableElements.addAll(this.getRule_MQRY_Port_ProvidedInterfaces_11(systemEngineering, ele));
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)ele)) {
                availableElements.addAll(InterfaceExt.filterLCRealizedInterfaces(tempAvailableElements));
            } else {
                availableElements = tempAvailableElements;
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        availableElements.remove(element);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Port_ProvidedInterfaces_11(SystemEngineering systemEng, Port element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = null;
        arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        availableElements.addAll(this.getElementsFromBlockArchitecture(arch, element));
        if (!(arch instanceof OperationalAnalysis)) {
            availableElements.addAll(this.getRule_MQRY_Port_ProvidedInterfaces_11_1(systemEng, element));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Port_ProvidedInterfaces_11_1(SystemEngineering systemEng, Port element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = null;
        arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEng);
        if (oa != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)oa, element));
        } else {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEng);
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ca, element));
        }
        if (arch != null) {
            if (oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture) {
                SystemAnalysis ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEng);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ctxArch, element));
            }
            if (arch instanceof PhysicalArchitecture) {
                LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEng);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)logArch, element));
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Port element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        InterfacePkg interfacePkg = arch.getOwnedInterfacePkg();
        if (interfacePkg != null) {
            for (Interface inter : InterfacePkgExt.getAllInterfaces((InterfacePkg)interfacePkg)) {
                if (inter == null) continue;
                availableElements.add((CapellaElement)inter);
            }
        }
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            EObject container;
            InterfacePkg intPkg = cpnt.getOwnedInterfacePkg();
            if (intPkg == null || (container = element.eContainer()) == null || !(container instanceof Component)) continue;
            availableElements.addAll(InterfacePkgExt.getAllInterfacesFiltered((InterfacePkg)intPkg, (Component)cpnt, (boolean)false));
        }
        return availableElements;
    }
}

