/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.filters.MultiFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.queries.filters.KeepClassWithSamePrimitiveStateFilter;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveEClassInstanceFilter;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveSubTypesFilter;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_Class_InheritedClasses
extends AbstractQuery {
    public List<Object> execute(Object inputElement, IQueryContext context) {
        List<Object> availableElements = new ArrayList<Object>();
        if (inputElement instanceof Class) {
            DataPkg rootDataPkg;
            Class currentClass = (Class)inputElement;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)currentClass);
            if (systemEngineering != null && (rootDataPkg = ClassExt.getRootOwnerDataPkg((Class)currentClass)) != null) {
                DataPkg dataPkg;
                Component parentComponent;
                availableElements.addAll(DataPkgExt.getAllClasses((DataPkg)rootDataPkg));
                availableElements.addAll(DataPkgExt.getClassesFromParentHierarchy((DataPkg)rootDataPkg));
                BlockArchitecture parentBlockArchitecture = DataPkgExt.getRootBlockArchitecture((ModelElement)rootDataPkg);
                if (parentBlockArchitecture != null) {
                    for (BlockArchitecture block : BlockArchitectureExt.getRootAndPreviousBlockArchitectures((EObject)parentBlockArchitecture)) {
                        List classes = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_CLASSES_IN_BLOCK_DATA_PACKAGE, (Object)block, (IQueryContext)context);
                        availableElements.addAll(classes);
                    }
                }
                if ((parentComponent = DataPkgExt.getRootComponent((DataPkg)rootDataPkg)) != null && (dataPkg = parentComponent.getOwnedDataPkg()) != null) {
                    availableElements.addAll(DataPkgExt.getAllClasses((DataPkg)dataPkg));
                }
            }
            availableElements = ListExt.removeDuplicates(availableElements);
            availableElements.remove(inputElement);
            MultiFilter filter = new MultiFilter(new IQueryFilter[]{new RemoveEClassInstanceFilter(InformationPackage.Literals.UNION), new RemoveSubTypesFilter((GeneralizableElement)currentClass), new KeepClassWithSamePrimitiveStateFilter(currentClass)});
            availableElements = QueryInterpretor.executeFilter(availableElements, (IQueryFilter)filter);
        }
        return availableElements;
    }
}

