/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.interaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_InteractionUse_ReferencedScenario
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        Scenario scenario = this.getAvailableRelatedScenario(element);
        BlockArchitecture currentBlockArchitecture = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (currentBlockArchitecture != null && scenario != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture(currentBlockArchitecture, scenario));
            availableElements.remove(scenario);
        }
        return availableElements;
    }

    protected Scenario getAvailableRelatedScenario(CapellaElement element) {
        if (element instanceof InteractionUse) {
            return (Scenario)((InteractionUse)element).eContainer();
        }
        if (element instanceof Scenario) {
            return (Scenario)element;
        }
        return null;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Scenario scenario) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        TreeIterator allContents = EcoreUtil.getAllContents((EObject)arch, (boolean)true);
        while (allContents.hasNext()) {
            Object object = allContents.next();
            if (!(object instanceof Scenario) || !((Scenario)object).getKind().equals((Object)scenario.getKind())) continue;
            if (arch instanceof OperationalAnalysis) {
                boolean isFSScenarioAvailable;
                boolean isFSScenario = ScenarioExt.isFunctionalScenario((Scenario)scenario);
                if (isFSScenario != (isFSScenarioAvailable = ScenarioExt.isFunctionalScenario((Scenario)((Scenario)object)))) continue;
                availableElements.add((CapellaElement)object);
                continue;
            }
            availableElements.add((CapellaElement)object);
        }
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        Scenario scenario = this.getCurrentRelatedScenario(element);
        if (scenario != null) {
            currentElements.add((CapellaElement)scenario);
        }
        return currentElements;
    }

    protected Scenario getCurrentRelatedScenario(CapellaElement element) {
        if (element instanceof InteractionUse) {
            return ((InteractionUse)element).getReferencedScenario();
        }
        if (element instanceof Scenario) {
            return (Scenario)element;
        }
        return null;
    }
}

