/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.oa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_CommunicationMean_AllocatedFunctionalExchanges
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<Object> availableElements = new ArrayList<EObject>();
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (arch == null) {
            return availableElements;
        }
        if (element instanceof CommunicationMean) {
            CommunicationMean currentCapabilityUseCase = (CommunicationMean)element;
            availableElements.addAll(this.getRule_MQRY_RealizableExchangesFromCommunicationMean(arch, currentCapabilityUseCase));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_RealizableExchangesFromCommunicationMean(BlockArchitecture sysEng, CommunicationMean element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        Entity sourceEntity = (Entity)element.getSource();
        Entity targetEntity = (Entity)element.getTarget();
        availableElements.addAll(this.getAllocationFunctionalExchangeByRoles(sourceEntity, targetEntity));
        EList functionalExchanges = element.getAllocatedFunctionalExchanges();
        for (FunctionalExchange functionalExchange : functionalExchanges) {
            availableElements.remove(functionalExchange);
        }
        return availableElements;
    }

    private Collection<? extends FunctionalExchange> getAllocationFunctionalExchangeByRoles(Entity sourceEntity, Entity targetEntity) {
        Component absFunBlock;
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        ArrayList<OperationalActivity> sourceActivities = new ArrayList<OperationalActivity>();
        ArrayList<OperationalActivity> targetActivities = new ArrayList<OperationalActivity>();
        Collection allSourceDescendants = ComponentExt.getAllSubUsedComponents((Component)sourceEntity);
        allSourceDescendants.add(sourceEntity);
        Collection allTargetDescendants = ComponentExt.getAllSubUsedComponents((Component)targetEntity);
        allTargetDescendants.add(targetEntity);
        for (Component component : allSourceDescendants) {
            if (component instanceof Entity) {
                for (RoleAllocation ra : ((Entity)component).getOwnedRoleAllocations()) {
                    for (ActivityAllocation aa : ra.getRole().getActivityAllocations()) {
                        sourceActivities.add(aa.getActivity());
                    }
                }
            }
            if (!(component instanceof AbstractFunctionalBlock)) continue;
            absFunBlock = component;
            sourceActivities.addAll((Collection<OperationalActivity>)absFunBlock.getAllocatedFunctions());
        }
        for (Component component : allTargetDescendants) {
            if (component instanceof Entity) {
                for (RoleAllocation ra : ((Entity)component).getOwnedRoleAllocations()) {
                    for (ActivityAllocation aa : ra.getRole().getActivityAllocations()) {
                        targetActivities.add(aa.getActivity());
                    }
                }
            }
            if (!(component instanceof AbstractFunctionalBlock)) continue;
            absFunBlock = component;
            targetActivities.addAll((Collection<OperationalActivity>)absFunBlock.getAllocatedFunctions());
        }
        for (AbstractFunction abstractFunction : sourceActivities) {
            List outGoingExchange = FunctionExt.getOutGoingExchange((AbstractFunction)abstractFunction);
            for (ActivityEdge trace : outGoingExchange) {
                FunctionalExchange fe;
                if (!(trace instanceof FunctionalExchange) || !targetActivities.contains((fe = (FunctionalExchange)trace).getTarget())) continue;
                result.add(fe);
            }
        }
        return result;
    }
}

