/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class TransitionHelper {
    private static TransitionHelper service;

    public static TransitionHelper getService() {
        if (service == null) {
            service = new TransitionHelper();
        }
        return service;
    }

    public boolean isFunctionalScenario(Scenario scenario) {
        if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
            return true;
        }
        if (scenario.getKind() == ScenarioKind.INTERACTION) {
            for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
                if (role.getRepresentedInstance() == null || !(role.getRepresentedInstance() instanceof AbstractFunction)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isES2ESTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW && (s.getKind() != ScenarioKind.INTERACTION || this.isFunctionalScenario(s))) continue;
                return false;
            }
            return scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERACTION && !this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isES2ISTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.INTERFACE) continue;
                return false;
            }
            if (scenario.getKind() != ScenarioKind.DATA_FLOW) {
                return false;
            }
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg || object instanceof Scenario);
    }

    public boolean isESF2ESBTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW) continue;
                return false;
            }
            if (scenario.getKind() == ScenarioKind.DATA_FLOW) {
                for (SequenceMessage message : scenario.getOwnedMessages()) {
                    AbstractEventOperation operation = message.getInvokedOperation();
                    if (operation == null || operation instanceof FunctionalExchange) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg || object instanceof Scenario);
    }

    public boolean isFS2ESForOASATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && this.isFS2ESTransitionAvailable(object);
    }

    public boolean isFS2ESForSALAPATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && (CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)object))) && this.isFS2ESTransitionAvailable(object);
    }

    public boolean isFS2ESTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario)) continue;
                Scenario s = (Scenario)src;
                BlockArchitecture architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
                if (architectureTarget != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW && s.getKind() != ScenarioKind.INTERACTION) continue;
                return false;
            }
            return this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isES2ESForOASATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && this.isES2ESTransitionAvailable(object);
    }

    public boolean isES2ESForSALATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)object)) && this.isES2ESTransitionAvailable(object);
    }

    public boolean isES2ESForLAPATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)object)) && this.isES2ESTransitionAvailable(object);
    }

    public boolean isInterfaceGenerationAvailable(EObject object) {
        PhysicalComponent pc;
        Component comp;
        if (object != null && (comp = this.getComponent(object)) != null && comp instanceof PhysicalComponent && (pc = (PhysicalComponent)comp).getNature() == PhysicalComponentNature.NODE) {
            return false;
        }
        return object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof Component || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof Component);
    }

    private Component getComponent(EObject object) {
        if (object != null) {
            Part part;
            AbstractType abstractType;
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Part && (abstractType = (part = (Part)object).getAbstractType()) instanceof Component) {
                return (Component)abstractType;
            }
        }
        return null;
    }

    public boolean isComponentExchangesGenerationAvailable(EObject object) {
        Component component = this.getComponent(object);
        if (component instanceof SystemComponent || component instanceof LogicalComponent) {
            return true;
        }
        if (component instanceof PhysicalComponent) {
            return ((PhysicalComponent)component).getNature() != PhysicalComponentNature.NODE || ((PhysicalComponent)component).isActor();
        }
        return false;
    }

    public boolean isCommunicationMeansGenerationAvailable(EObject object) {
        Component component = this.getComponent(object);
        return component instanceof Entity;
    }

    public boolean isPhysicalLinksGenerationAvailable(EObject object) {
        EObject component = object;
        if (object instanceof Part) {
            component = ((Part)object).getAbstractType();
        }
        if (component instanceof Component) {
            if (component instanceof PhysicalComponent) {
                return ((PhysicalComponent)component).getNature() != PhysicalComponentNature.BEHAVIOR;
            }
            if (this.canHavePhysicalPort(component)) {
                return true;
            }
            return component instanceof PhysicalComponent && !((Component)component).isActor();
        }
        return false;
    }

    public boolean canHavePhysicalPort(EObject source) {
        return source instanceof PhysicalComponent || source instanceof Component && ((Component)source).isActor() || source instanceof SystemComponent || source instanceof LogicalComponent && source == ComponentExt.getRootBlockArchitecture((ModelElement)((LogicalComponent)source)).getSystem();
    }

    public boolean isFS2FSTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && architectureTarget.equals(architectureSource) || !this.isFunctionalScenario(s)) continue;
                return false;
            }
            return this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isFS2FSForOASATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && this.isFS2FSTransitionAvailable(object);
    }

    public boolean isFS2FSForSALATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)object)) && this.isFS2FSTransitionAvailable(object);
    }

    public boolean isFS2FSForLAPATransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)object)) && this.isFS2FSTransitionAvailable(object);
    }

    public boolean isPropertyValueTransitionAvailable(EObject object) {
        return object instanceof CapellaElement && (object instanceof PropertyValueGroup || object instanceof PropertyValuePkg || object instanceof AbstractPropertyValue || object instanceof EnumerationPropertyType) && EcoreUtil2.isContainedBy((EObject)object, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE) && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)object));
    }

    public boolean isIS2ISSALATransitionAvailable(EObject element) {
        return element instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)element)) && this.isIS2ISTransitionAvailable(element, "SALA");
    }

    public boolean isIS2ISLAPATransitionAvailable(EObject element) {
        return element instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)element)) && this.isIS2ISTransitionAvailable(element, "LAPA");
    }

    public boolean isIS2ISPAEPBSTransitionAvailable(EObject element) {
        return element instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)element)) && this.isIS2ISTransitionAvailable(element, "PAEPBS");
    }

    private boolean isIS2ISTransitionAvailable(EObject object, String transition) {
        if (object instanceof Scenario && ((Scenario)object).getKind() == ScenarioKind.INTERFACE) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario existingScenario;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (existingScenario = (Scenario)src).getKind() != ScenarioKind.INTERFACE) continue;
                BlockArchitecture architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)existingScenario);
                if (!("SALA".equals(transition) ? architectureSource instanceof SystemAnalysis && architectureTarget instanceof LogicalArchitecture : ("LAPA".equals(transition) ? architectureSource instanceof LogicalArchitecture && architectureTarget instanceof PhysicalArchitecture : "PAEPBS".equals(transition) && architectureSource instanceof PhysicalArchitecture && architectureTarget instanceof EPBSArchitecture))) continue;
                return false;
            }
            return true;
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg;
    }
}

