/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerLabelProvider;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class AddSourceContainerDialog
extends TitleAreaDialog {
    private TableViewer fViewer;
    private SourceContainerViewer fSourceContainerViewer;
    private ISourceLookupDirector fDirector;

    public AddSourceContainerDialog(Shell shell, SourceContainerViewer viewer, ISourceLookupDirector director) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSourceContainerViewer = viewer;
        this.fDirector = director;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SourceLookupUIMessages.addSourceLocation_title);
        this.setTitle(SourceLookupUIMessages.addSourceLocation_description);
        this.setTitleImage(DebugPluginImages.getImage("IMG_ADD_SRC_LOCATION"));
        this.setMessage(SourceLookupUIMessages.AddSourceContainerDialog_select_source_container);
        Composite comp = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        comp.setLayout((Layout)topLayout);
        comp.setLayoutData((Object)gd);
        ISourceContainerType[] types = this.filterTypes(DebugPlugin.getDefault().getLaunchManager().getSourceContainerTypes());
        this.fViewer = new TableViewer(comp, 2820);
        Table table = this.fViewer.getTable();
        gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddSourceContainerDialog.this.okPressed();
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new SourceContainerLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setComparator(new ViewerComparator());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                if (!selection.isEmpty()) {
                    ISourceContainerType type = (ISourceContainerType)selection.getFirstElement();
                    AddSourceContainerDialog.this.setMessage(type.getDescription());
                    AddSourceContainerDialog.this.getButton(0).setEnabled(true);
                } else {
                    AddSourceContainerDialog.this.getButton(0).setEnabled(false);
                    AddSourceContainerDialog.this.setMessage(SourceLookupUIMessages.AddSourceContainerDialog_select_source_container);
                }
            }
        });
        if (types.length != 0) {
            this.fViewer.setInput((Object)types);
        }
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.debug.ui.add_source_container_dialog");
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Table table = this.fViewer.getTable();
        if (table.getItemCount() > 0) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(0).getData()));
        }
    }

    protected void okPressed() {
        ISourceContainerBrowser browser;
        ISourceContainerType type = (ISourceContainerType)this.fViewer.getStructuredSelection().getFirstElement();
        if (type != null && (browser = DebugUITools.getSourceContainerBrowser(type.getId())) != null) {
            ISourceContainer[] results = browser.addSourceContainers(this.getShell(), this.fDirector);
            if (results != null && results.length > 0) {
                this.fSourceContainerViewer.addEntries(results);
                super.okPressed();
            } else {
                return;
            }
        }
        super.okPressed();
    }

    private ISourceContainerType[] filterTypes(ISourceContainerType[] types) {
        ArrayList<ISourceContainerType> validTypes = new ArrayList<ISourceContainerType>();
        ISourceContainerType[] iSourceContainerTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainerBrowser sourceContainerBrowser;
            ISourceContainerType type = iSourceContainerTypeArray[n2];
            if (this.fDirector.supportsSourceContainerType(type) && (sourceContainerBrowser = DebugUITools.getSourceContainerBrowser(type.getId())) != null && sourceContainerBrowser.canAddSourceContainers(this.fDirector)) {
                validTypes.add(type);
            }
            ++n2;
        }
        return validTypes.toArray(new ISourceContainerType[validTypes.size()]);
    }
}

