/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.handlers.location;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.re.handlers.location.SpecificPackageSupplierFactory;

class SpecificPackageLocationAdapter
extends AdapterImpl {
    private final SpecificPackageSupplierFactory factory;
    private final Collection<EObject> created = new HashSet<EObject>();

    SpecificPackageLocationAdapter(final IPropertyContext context, Resource destinationResource) {
        context.registerListener(new PropertyChangeListener(){

            public void update(PropertyChangedEvent event) {
                if ("targetName".equals(event.getProperty().getId())) {
                    for (EObject pkg : SpecificPackageLocationAdapter.this.created) {
                        if (!(pkg instanceof NamedElement)) continue;
                        ((NamedElement)pkg).setName((String)context.getCurrentValue(event.getProperty()));
                    }
                }
            }
        });
        this.factory = new SpecificPackageSupplierFactory(destinationResource);
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == RePackage.Literals.RE_NAMED_ELEMENT__NAME) {
            for (EObject pkg : this.created) {
                if (!(pkg instanceof NamedElement)) continue;
                ((NamedElement)pkg).setName((String)msg.getNewValue());
            }
        }
    }

    public Supplier<EObject> getSpecificPackage(EObject packagedElement) {
        Supplier<EObject> result = null;
        final Supplier<EObject> pkgSupplier = this.factory.getSpecificPackageSupplier(packagedElement);
        if (pkgSupplier != null) {
            result = new Supplier<EObject>(){

                @Override
                public EObject get() {
                    EObject pkg = (EObject)pkgSupplier.get();
                    SpecificPackageLocationAdapter.this.created.add(pkg);
                    if (pkg instanceof NamedElement) {
                        ((NamedElement)pkg).setName(((CatalogElement)SpecificPackageLocationAdapter.this.getTarget()).getName());
                    }
                    return pkg;
                }
            };
        }
        return result;
    }

    public void dispose() {
        this.getTarget().eAdapters().remove((Object)this);
        for (EObject next : this.created) {
            EObject container;
            if (!next.eContents().isEmpty() || (container = next.eContainer()) == null) continue;
            ((Collection)container.eGet(next.eContainingFeature())).remove(next);
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == SpecificPackageLocationAdapter.class;
    }
}

